/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.jol.info;

import io.github.insideranh.stellarprotect.libs.jol.info.AbstractGraphWalker;
import io.github.insideranh.stellarprotect.libs.jol.info.ArrayGraphPathRecord;
import io.github.insideranh.stellarprotect.libs.jol.info.FieldGraphPathRecord;
import io.github.insideranh.stellarprotect.libs.jol.info.GraphLayout;
import io.github.insideranh.stellarprotect.libs.jol.info.GraphPathRecord;
import io.github.insideranh.stellarprotect.libs.jol.info.GraphVisitor;
import io.github.insideranh.stellarprotect.libs.jol.util.ObjectUtils;
import io.github.insideranh.stellarprotect.libs.jol.util.SimpleIdentityHashSet;
import io.github.insideranh.stellarprotect.libs.jol.util.SimpleStack;
import io.github.insideranh.stellarprotect.libs.jol.vm.VM;
import java.lang.reflect.Field;
import java.util.HashMap;

public class GraphWalker
extends AbstractGraphWalker {
    private final GraphVisitor[] visitors;
    private final HashMap<Class<?>, Long> sizeCache;

    public GraphWalker(GraphVisitor ... visitor) {
        this.visitors = visitor;
        this.sizeCache = new HashMap();
    }

    public GraphLayout walk(Object ... roots) {
        this.verifyRoots(roots);
        GraphLayout data = new GraphLayout(roots);
        SimpleIdentityHashSet visited = new SimpleIdentityHashSet();
        SimpleStack<GraphPathRecord> s = new SimpleStack<GraphPathRecord>();
        int rootId = 1;
        boolean single = roots.length == 1;
        for (Object root : roots) {
            String label = single ? "" : "<r" + rootId + ">";
            FieldGraphPathRecord e = new FieldGraphPathRecord(null, label, 0, root);
            if (visited.add(root)) {
                data.addRecord(e);
                s.push(e);
            }
            ++rootId;
        }
        while (!s.isEmpty()) {
            GraphPathRecord cGpr = (GraphPathRecord)s.pop();
            Object o = cGpr.obj();
            Class<?> cl = o.getClass();
            if (cl.isArray()) {
                if (cl.getComponentType().isPrimitive()) continue;
                Object[] arr = (Object[])o;
                for (int i = 0; i < arr.length; ++i) {
                    Object e = arr[i];
                    if (e == null || !visited.add(e)) continue;
                    ArrayGraphPathRecord gpr = new ArrayGraphPathRecord(cGpr, i, cGpr.depth() + 1, e);
                    data.addRecord(gpr);
                    for (GraphVisitor v : this.visitors) {
                        v.visit(gpr);
                    }
                    s.push(gpr);
                }
                continue;
            }
            Long knownSize = this.sizeCache.get(cl);
            if (knownSize == null) {
                knownSize = VM.current().sizeOf(o);
                this.sizeCache.put(cl, knownSize);
            }
            cGpr.setSize(knownSize);
            for (Field f : this.getAllReferenceFields(cl)) {
                Object e = ObjectUtils.value(o, f);
                if (e == null || !visited.add(e)) continue;
                FieldGraphPathRecord gpr = new FieldGraphPathRecord(cGpr, f.getName(), cGpr.depth() + 1, e);
                data.addRecord(gpr);
                for (GraphVisitor v : this.visitors) {
                    v.visit(gpr);
                }
                s.push(gpr);
            }
        }
        return data;
    }
}

