/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.foliascheduler;

import io.github.insideranh.stellarprotect.libs.foliascheduler.ServerImplementation;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class FoliaCompatibility {
    @NotNull
    private final ServerImplementation serverImplementation;

    public FoliaCompatibility(@NotNull Plugin plugin) {
        ServerImplementation scheduler;
        FoliaCompatibility.assertRelocated(plugin);
        try {
            try {
                Server.class.getMethod("isOwnedByCurrentRegion", Location.class);
                scheduler = Class.forName(this.getClass().getPackage().getName() + ".folia.FoliaServer").asSubclass(ServerImplementation.class).getConstructor(Plugin.class).newInstance(plugin);
            }
            catch (NoSuchMethodException ex) {
                scheduler = Class.forName(this.getClass().getPackage().getName() + ".bukkit.BukkitServer").asSubclass(ServerImplementation.class).getConstructor(Plugin.class).newInstance(plugin);
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException("Failed to initialize scheduler", ex);
        }
        this.serverImplementation = scheduler;
    }

    @NotNull
    public ServerImplementation getServerImplementation() {
        return this.serverImplementation;
    }

    private static void assertRelocated(@NotNull Plugin plugin) {
        String relocatedPackage;
        String originalPackage = String.join((CharSequence)".", "com", "cjcrafter", "scheduler");
        if (originalPackage.equals(relocatedPackage = FoliaCompatibility.class.getPackage().getName())) {
            String authors = String.join((CharSequence)", ", plugin.getDescription().getAuthors());
            String possiblePackage = plugin.getClass().getPackage().getName() + ".libs.scheduler";
            plugin.getLogger().warning("The FoliaScheduler lib has not been relocated!");
            plugin.getLogger().warning("The package is still in '" + originalPackage + "'");
            plugin.getLogger().warning("Please relocate the lib to '" + possiblePackage + "'");
            plugin.getLogger().warning("Please warn authors " + authors + " about this issue.");
        }
    }
}

