/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.bson.codecs.pojo;

import io.github.insideranh.stellarprotect.libs.bson.BsonReader;
import io.github.insideranh.stellarprotect.libs.bson.BsonType;
import io.github.insideranh.stellarprotect.libs.bson.BsonWriter;
import io.github.insideranh.stellarprotect.libs.bson.codecs.Codec;
import io.github.insideranh.stellarprotect.libs.bson.codecs.DecoderContext;
import io.github.insideranh.stellarprotect.libs.bson.codecs.EncoderContext;
import io.github.insideranh.stellarprotect.libs.bson.codecs.RepresentationConfigurable;
import io.github.insideranh.stellarprotect.libs.bson.codecs.configuration.CodecConfigurationException;
import io.github.insideranh.stellarprotect.libs.bson.codecs.configuration.CodecRegistry;
import io.github.insideranh.stellarprotect.libs.bson.codecs.pojo.ClassModel;
import io.github.insideranh.stellarprotect.libs.bson.codecs.pojo.DiscriminatorLookup;
import io.github.insideranh.stellarprotect.libs.bson.codecs.pojo.IdPropertyModelHolder;
import io.github.insideranh.stellarprotect.libs.bson.codecs.pojo.LazyMissingCodec;
import io.github.insideranh.stellarprotect.libs.bson.codecs.pojo.PojoCodec;
import io.github.insideranh.stellarprotect.libs.bson.codecs.pojo.PojoCodecImpl;
import io.github.insideranh.stellarprotect.libs.bson.codecs.pojo.PojoSpecializationHelper;
import io.github.insideranh.stellarprotect.libs.bson.codecs.pojo.PropertyCodecRegistry;
import io.github.insideranh.stellarprotect.libs.bson.codecs.pojo.PropertyModel;
import io.github.insideranh.stellarprotect.libs.bson.codecs.pojo.TypeData;
import io.github.insideranh.stellarprotect.libs.bson.codecs.pojo.TypeParameterMap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class LazyPropertyModelCodec<T>
implements Codec<T> {
    private final PropertyModel<T> propertyModel;
    private final CodecRegistry registry;
    private final PropertyCodecRegistry propertyCodecRegistry;
    private final Lock codecLock = new ReentrantLock();
    private volatile Codec<T> codec;

    LazyPropertyModelCodec(PropertyModel<T> propertyModel, CodecRegistry registry, PropertyCodecRegistry propertyCodecRegistry) {
        this.propertyModel = propertyModel;
        this.registry = registry;
        this.propertyCodecRegistry = propertyCodecRegistry;
    }

    @Override
    public T decode(BsonReader reader, DecoderContext decoderContext) {
        return this.getPropertyModelCodec().decode(reader, decoderContext);
    }

    @Override
    public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        this.getPropertyModelCodec().encode(writer, value, encoderContext);
    }

    @Override
    public Class<T> getEncoderClass() {
        return this.propertyModel.getTypeData().getType();
    }

    private Codec<T> getPropertyModelCodec() {
        Codec<T> codec = this.codec;
        if (codec == null) {
            this.codecLock.lock();
            try {
                codec = this.codec;
                if (codec == null) {
                    this.codec = codec = this.createCodec();
                }
            }
            finally {
                this.codecLock.unlock();
            }
        }
        return codec;
    }

    private Codec<T> createCodec() {
        Codec<T> localCodec = this.getCodecFromPropertyRegistry(this.propertyModel);
        if (localCodec instanceof PojoCodec) {
            PojoCodec pojoCodec = (PojoCodec)localCodec;
            ClassModel specialized = this.getSpecializedClassModel(pojoCodec.getClassModel(), this.propertyModel);
            localCodec = new PojoCodecImpl(specialized, this.registry, this.propertyCodecRegistry, pojoCodec.getDiscriminatorLookup());
        }
        return localCodec;
    }

    private Codec<T> getCodecFromPropertyRegistry(PropertyModel<T> propertyModel) {
        BsonType representation;
        Codec<T> localCodec;
        try {
            localCodec = this.propertyCodecRegistry.get(propertyModel.getTypeData());
        }
        catch (CodecConfigurationException e) {
            return new LazyMissingCodec<T>(propertyModel.getTypeData().getType(), e);
        }
        if (localCodec == null) {
            localCodec = new LazyMissingCodec<T>(propertyModel.getTypeData().getType(), new CodecConfigurationException("Unexpected missing codec for: " + propertyModel.getName()));
        }
        if ((representation = propertyModel.getBsonRepresentation()) != null) {
            if (localCodec instanceof RepresentationConfigurable) {
                return ((RepresentationConfigurable)((Object)localCodec)).withRepresentation(representation);
            }
            throw new CodecConfigurationException("Codec must implement RepresentationConfigurable to support BsonRepresentation");
        }
        return localCodec;
    }

    private <V> ClassModel<T> getSpecializedClassModel(ClassModel<T> clazzModel, PropertyModel<V> propertyModel) {
        boolean changeTheDiscriminator;
        boolean useDiscriminator = propertyModel.useDiscriminator() == null ? clazzModel.useDiscriminator() : propertyModel.useDiscriminator().booleanValue();
        boolean validDiscriminator = clazzModel.getDiscriminatorKey() != null && clazzModel.getDiscriminator() != null;
        boolean bl = changeTheDiscriminator = useDiscriminator != clazzModel.useDiscriminator() && validDiscriminator;
        if (propertyModel.getTypeData().getTypeParameters().isEmpty() && !changeTheDiscriminator) {
            return clazzModel;
        }
        ArrayList concretePropertyModels = new ArrayList(clazzModel.getPropertyModels());
        PropertyModel<?> concreteIdProperty = clazzModel.getIdPropertyModel();
        List<TypeData<?>> propertyTypeParameters = propertyModel.getTypeData().getTypeParameters();
        for (int i = 0; i < concretePropertyModels.size(); ++i) {
            PropertyModel<?> model = concretePropertyModels.get(i);
            String propertyName = model.getName();
            TypeParameterMap typeParameterMap = clazzModel.getPropertyNameToTypeParameterMap().get(propertyName);
            if (!typeParameterMap.hasTypeParameters()) continue;
            PropertyModel<?> concretePropertyModel = this.getSpecializedPropertyModel(model, propertyTypeParameters, typeParameterMap);
            concretePropertyModels.set(i, concretePropertyModel);
            if (concreteIdProperty == null || !concreteIdProperty.getName().equals(propertyName)) continue;
            concreteIdProperty = concretePropertyModel;
        }
        boolean discriminatorEnabled = changeTheDiscriminator ? propertyModel.useDiscriminator().booleanValue() : clazzModel.useDiscriminator();
        return new ClassModel<T>(clazzModel.getType(), clazzModel.getPropertyNameToTypeParameterMap(), clazzModel.getInstanceCreatorFactory(), discriminatorEnabled, clazzModel.getDiscriminatorKey(), clazzModel.getDiscriminator(), IdPropertyModelHolder.create(clazzModel, concreteIdProperty), concretePropertyModels);
    }

    private <V> PropertyModel<V> getSpecializedPropertyModel(PropertyModel<V> propertyModel, List<TypeData<?>> propertyTypeParameters, TypeParameterMap typeParameterMap) {
        TypeData<V> specializedPropertyType = PojoSpecializationHelper.specializeTypeData(propertyModel.getTypeData(), propertyTypeParameters, typeParameterMap);
        if (propertyModel.getTypeData().equals(specializedPropertyType)) {
            return propertyModel;
        }
        return new PropertyModel<V>(propertyModel.getName(), propertyModel.getReadName(), propertyModel.getWriteName(), specializedPropertyType, null, propertyModel.getPropertySerialization(), propertyModel.useDiscriminator(), propertyModel.getPropertyAccessor(), propertyModel.getError(), propertyModel.getBsonRepresentation());
    }

    static final class NeedSpecializationCodec<T>
    extends PojoCodec<T> {
        private final ClassModel<T> classModel;
        private final DiscriminatorLookup discriminatorLookup;
        private final CodecRegistry codecRegistry;

        NeedSpecializationCodec(ClassModel<T> classModel, DiscriminatorLookup discriminatorLookup, CodecRegistry codecRegistry) {
            this.classModel = classModel;
            this.discriminatorLookup = discriminatorLookup;
            this.codecRegistry = codecRegistry;
        }

        @Override
        public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
            if (value.getClass().equals(this.classModel.getType())) {
                throw this.exception();
            }
            this.tryEncode(this.codecRegistry.get(value.getClass()), writer, value, encoderContext);
        }

        @Override
        public T decode(BsonReader reader, DecoderContext decoderContext) {
            return this.tryDecode(reader, decoderContext);
        }

        private <A> void tryEncode(Codec<A> codec, BsonWriter writer, T value, EncoderContext encoderContext) {
            try {
                codec.encode(writer, value, encoderContext);
            }
            catch (Exception e) {
                throw this.exception();
            }
        }

        public T tryDecode(BsonReader reader, DecoderContext decoderContext) {
            Codec codec = PojoCodecImpl.getCodecFromDocument(reader, this.classModel.useDiscriminator(), this.classModel.getDiscriminatorKey(), this.codecRegistry, this.discriminatorLookup, null, this.classModel.getName());
            if (codec != null) {
                return codec.decode(reader, decoderContext);
            }
            throw this.exception();
        }

        @Override
        public Class<T> getEncoderClass() {
            return this.classModel.getType();
        }

        private CodecConfigurationException exception() {
            return new CodecConfigurationException(String.format("%s contains generic types that have not been specialised.%nTop level classes with generic types are not supported by the PojoCodec.", this.classModel.getName()));
        }

        @Override
        ClassModel<T> getClassModel() {
            return this.classModel;
        }

        @Override
        DiscriminatorLookup getDiscriminatorLookup() {
            return this.discriminatorLookup;
        }
    }
}

