/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.bson.codecs;

import io.github.insideranh.stellarprotect.libs.bson.BsonBinary;
import io.github.insideranh.stellarprotect.libs.bson.BsonBinarySubType;
import io.github.insideranh.stellarprotect.libs.bson.BsonInvalidOperationException;
import io.github.insideranh.stellarprotect.libs.bson.BsonReader;
import io.github.insideranh.stellarprotect.libs.bson.BsonWriter;
import io.github.insideranh.stellarprotect.libs.bson.Int8BinaryVector;
import io.github.insideranh.stellarprotect.libs.bson.codecs.Codec;
import io.github.insideranh.stellarprotect.libs.bson.codecs.DecoderContext;
import io.github.insideranh.stellarprotect.libs.bson.codecs.EncoderContext;

final class Int8VectorCodec
implements Codec<Int8BinaryVector> {
    Int8VectorCodec() {
    }

    @Override
    public void encode(BsonWriter writer, Int8BinaryVector vectorToEncode, EncoderContext encoderContext) {
        writer.writeBinaryData(new BsonBinary(vectorToEncode));
    }

    @Override
    public Int8BinaryVector decode(BsonReader reader, DecoderContext decoderContext) {
        byte subType = reader.peekBinarySubType();
        if (subType != BsonBinarySubType.VECTOR.getValue()) {
            throw new BsonInvalidOperationException("Expected vector binary subtype " + BsonBinarySubType.VECTOR.getValue() + " but found: " + subType);
        }
        return reader.readBinaryData().asBinary().asVector().asInt8Vector();
    }

    @Override
    public Class<Int8BinaryVector> getEncoderClass() {
        return Int8BinaryVector.class;
    }
}

