/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.database.types.mongo;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.arguments.DatabaseFilters;
import io.github.insideranh.stellarprotect.arguments.RadiusArg;
import io.github.insideranh.stellarprotect.arguments.TimeArg;
import io.github.insideranh.stellarprotect.arguments.UsersArg;
import io.github.insideranh.stellarprotect.cache.LoggerCache;
import io.github.insideranh.stellarprotect.cache.PlayerCache;
import io.github.insideranh.stellarprotect.cache.keys.LocationCache;
import io.github.insideranh.stellarprotect.callback.CallbackLookup;
import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.database.repositories.RestoreRepository;
import io.github.insideranh.stellarprotect.database.types.factory.LogEntryFactory;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.libs.bson.Document;
import io.github.insideranh.stellarprotect.libs.bson.conversions.Bson;
import io.github.insideranh.stellarprotect.libs.mongodb.client.FindIterable;
import io.github.insideranh.stellarprotect.libs.mongodb.client.MongoCollection;
import io.github.insideranh.stellarprotect.libs.mongodb.client.MongoDatabase;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.Filters;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.Sorts;
import io.github.insideranh.stellarprotect.utils.Debugger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import lombok.NonNull;

public class RestoreRepositoryMongo
implements RestoreRepository {
    private final StellarProtect stellarProtect = StellarProtect.getInstance();
    private final MongoDatabase database;
    private final MongoCollection<Document> players;
    private final MongoCollection<Document> logEntries;

    public RestoreRepositoryMongo(MongoDatabase database) {
        this.database = database;
        this.players = database.getCollection(this.stellarProtect.getConfigManager().getTablesPlayers());
        this.logEntries = database.getCollection(this.stellarProtect.getConfigManager().getTablesLogEntries());
    }

    @Override
    public CompletableFuture<CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long>> getRestoreActions(@NonNull DatabaseFilters filters, int skip, int limit) {
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        return CompletableFuture.supplyAsync(() -> {
            TimeArg timeArg = filters.getTimeFilter();
            RadiusArg radiusArg = filters.getRadiusFilter();
            List<Integer> actionTypes = filters.getActionTypesFilter();
            ArrayList<ActionType> actionTypeObjects = actionTypes != null ? actionTypes.stream().map(ActionType::getById).filter(Objects::nonNull).collect(Collectors.toList()) : new ArrayList<ActionType>();
            List<Object> cachedLogs = new ArrayList();
            if (!filters.isIgnoreCache() && !actionTypeObjects.isEmpty()) {
                cachedLogs = LoggerCache.getLogs(timeArg, radiusArg, actionTypeObjects, skip, limit).stream().sorted(Comparator.comparingLong(LogEntry::getCreatedAt).reversed()).collect(Collectors.toList());
            }
            Map groupedResults = cachedLogs.stream().collect(Collectors.groupingBy(LocationCache::of, LinkedHashMap::new, Collectors.toCollection(LinkedHashSet::new)));
            int remaining = limit - cachedLogs.size();
            if (remaining > 0) {
                int dbSkip = skip + cachedLogs.size();
                CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long> dbLookup = this.queryLogsFromDB(filters, dbSkip, remaining);
                List<Object> finalCachedLogs = cachedLogs;
                List dbLogs = dbLookup.getLogs().values().stream().flatMap(Collection::stream).filter(log -> finalCachedLogs.stream().noneMatch(c -> c.equals(log))).sorted(Comparator.comparingLong(LogEntry::getCreatedAt).reversed()).limit(remaining).collect(Collectors.toList());
                Map dbGrouped = dbLogs.stream().collect(Collectors.groupingBy(LocationCache::of, LinkedHashMap::new, Collectors.toCollection(LinkedHashSet::new)));
                dbGrouped.forEach((location, logs) -> groupedResults.merge(location, logs, (existing, newLogs) -> {
                    existing.addAll(newLogs);
                    return existing;
                }));
                return new CallbackLookup<Map, Long>(groupedResults, dbLookup.getTotal());
            }
            return new CallbackLookup<Map, Long>(groupedResults, (long)skip + (long)cachedLogs.size());
        }, (Executor)this.stellarProtect.getLookupExecutor());
    }

    @Override
    public CompletableFuture<Long> countRestoreActions(@NonNull DatabaseFilters filters) {
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        return CompletableFuture.supplyAsync(() -> {
            TimeArg timeArg = filters.getTimeFilter();
            RadiusArg radiusArg = filters.getRadiusFilter();
            List<Integer> actionTypes = filters.getActionTypesFilter();
            ArrayList<ActionType> actionTypeObjects = actionTypes != null ? actionTypes.stream().map(ActionType::getById).filter(Objects::nonNull).collect(Collectors.toList()) : new ArrayList<ActionType>();
            long cachedCount = 0L;
            if (!filters.isIgnoreCache() && !actionTypeObjects.isEmpty()) {
                cachedCount = LoggerCache.countLogs(timeArg, radiusArg, actionTypeObjects);
            }
            long dbCount = this.countLogsFromDB(filters);
            return cachedCount + dbCount;
        }, (Executor)this.stellarProtect.getLookupExecutor());
    }

    private long countLogsFromDB(DatabaseFilters filters) {
        Bson filter = this.buildFilters(filters);
        return this.logEntries.countDocuments(filter);
    }

    private CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long> queryLogsFromDB(DatabaseFilters filters, int skip, int limit) {
        LinkedHashSet<LogEntry> logs = new LinkedHashSet<LogEntry>();
        Bson filter = this.buildFilters(filters);
        long totalCount = this.logEntries.countDocuments(filter);
        FindIterable<Document> logDocs = this.logEntries.find(filter).sort(Sorts.descending("created_at")).skip(skip).limit(limit);
        for (Document doc : logDocs) {
            long playerId = doc.getLong("player_id");
            Document playerDoc = (Document)this.players.find(Filters.eq("id", playerId)).first();
            if (playerDoc != null) {
                String playerName = playerDoc.getString("name");
                PlayerCache.cacheName(playerId, playerName);
            }
            try {
                LogEntry entry = LogEntryFactory.fromDocument(doc);
                logs.add(entry);
            }
            catch (Exception e) {
                Debugger.debugLog("Error al cargar log: " + doc.toJson());
            }
        }
        Map groupedLogs = logs.stream().collect(Collectors.groupingBy(LocationCache::of, LinkedHashMap::new, Collectors.toCollection(LinkedHashSet::new)));
        return new CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long>(groupedLogs, totalCount);
    }

    private Bson buildFilters(DatabaseFilters databaseFilters) {
        TimeArg timeArg = databaseFilters.getTimeFilter();
        RadiusArg radiusArg = databaseFilters.getRadiusFilter();
        UsersArg usersArg = databaseFilters.getUserFilters();
        List<Integer> actionTypes = databaseFilters.getActionTypesFilter();
        List<Long> includeFilter = databaseFilters.getAllIncludeFilters();
        List<Long> excludeFilter = databaseFilters.getAllExcludeFilters();
        ArrayList<Bson> filters = new ArrayList<Bson>();
        if (timeArg != null) {
            filters.add(Filters.gte("created_at", timeArg.getStart()));
            filters.add(Filters.lte("created_at", timeArg.getEnd()));
        }
        if (radiusArg != null) {
            if (radiusArg.getWorldId() != -1) {
                filters.add(Filters.eq("world_id", radiusArg.getWorldId()));
            }
            filters.add(Filters.gte("x", radiusArg.getMinX()));
            filters.add(Filters.lte("x", radiusArg.getMaxX()));
            filters.add(Filters.gte("y", radiusArg.getMinY()));
            filters.add(Filters.lte("y", radiusArg.getMaxY()));
            filters.add(Filters.gte("z", radiusArg.getMinZ()));
            filters.add(Filters.lte("z", radiusArg.getMaxZ()));
        }
        if (usersArg != null && usersArg.getUserIds() != null && !usersArg.getUserIds().isEmpty()) {
            filters.add(Filters.in("player_id", usersArg.getUserIds()));
        }
        if (actionTypes != null && !actionTypes.isEmpty()) {
            filters.add(Filters.in("action_type", actionTypes));
        }
        if (includeFilter != null && !includeFilter.isEmpty()) {
            filters.add(this.buildIncludeFilter(includeFilter));
        }
        if (excludeFilter != null && !excludeFilter.isEmpty()) {
            filters.add(this.buildExcludeFilter(excludeFilter));
        }
        return filters.isEmpty() ? new Document() : Filters.and(filters);
    }

    private Bson buildIncludeFilter(List<Long> includeFilter) {
        if (includeFilter.size() == 1) {
            Long itemId = includeFilter.get(0);
            return Filters.text("\"id\":" + itemId + " OR \"ai\":{\"" + itemId + "\" OR \"ri\":{\"" + itemId + "\"");
        }
        ArrayList<Bson> conditions = new ArrayList<Bson>();
        for (Long itemId : includeFilter) {
            conditions.add(Filters.text("\"id\":" + itemId + " OR \"ai\":{\"" + itemId + "\" OR \"ri\":{\"" + itemId + "\""));
        }
        return Filters.or(conditions);
    }

    private Bson buildExcludeFilter(List<Long> excludeFilter) {
        ArrayList<Bson> excludeConditions = new ArrayList<Bson>();
        for (Long itemId : excludeFilter) {
            ArrayList<Bson> singleExcludeConditions = new ArrayList<Bson>();
            singleExcludeConditions.add(Filters.not(Filters.regex("extra_json", ".*\"id\"\\s*:\\s*\"?" + itemId + "\"?\\s*[,}].*")));
            singleExcludeConditions.add(Filters.not(Filters.regex("extra_json", ".*\"ai\"\\s*:\\s*\\{[^}]*\"" + itemId + "\"\\s*:\\s*\\d+.*")));
            singleExcludeConditions.add(Filters.not(Filters.regex("extra_json", ".*\"ri\"\\s*:\\s*\\{[^}]*\"" + itemId + "\"\\s*:\\s*\\d+.*")));
            excludeConditions.add(Filters.and(singleExcludeConditions));
        }
        return excludeConditions.size() == 1 ? (Bson)excludeConditions.get(0) : Filters.and(excludeConditions);
    }
}

