/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.database.types.mongo;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.arguments.DatabaseFilters;
import io.github.insideranh.stellarprotect.arguments.RadiusArg;
import io.github.insideranh.stellarprotect.arguments.TimeArg;
import io.github.insideranh.stellarprotect.arguments.UsersArg;
import io.github.insideranh.stellarprotect.cache.LoggerCache;
import io.github.insideranh.stellarprotect.cache.PlayerCache;
import io.github.insideranh.stellarprotect.cache.keys.LocationCache;
import io.github.insideranh.stellarprotect.callback.CallbackLookup;
import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.database.entries.items.ItemLogEntry;
import io.github.insideranh.stellarprotect.database.entries.players.PlayerTransactionEntry;
import io.github.insideranh.stellarprotect.database.repositories.LoggerRepository;
import io.github.insideranh.stellarprotect.database.types.factory.LogEntryFactory;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.items.ItemTemplate;
import io.github.insideranh.stellarprotect.libs.bson.Document;
import io.github.insideranh.stellarprotect.libs.bson.conversions.Bson;
import io.github.insideranh.stellarprotect.libs.mongodb.bulk.BulkWriteResult;
import io.github.insideranh.stellarprotect.libs.mongodb.client.AggregateIterable;
import io.github.insideranh.stellarprotect.libs.mongodb.client.FindIterable;
import io.github.insideranh.stellarprotect.libs.mongodb.client.MongoCollection;
import io.github.insideranh.stellarprotect.libs.mongodb.client.MongoDatabase;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.Aggregates;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.BulkWriteOptions;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.Filters;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.InsertOneModel;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.ReplaceOneModel;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.Sorts;
import io.github.insideranh.stellarprotect.libs.mongodb.client.result.DeleteResult;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import io.github.insideranh.stellarprotect.utils.Debugger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;

public class LoggerRepositoryMongo
implements LoggerRepository {
    private final StellarProtect stellarProtect = StellarProtect.getInstance();
    private final MongoDatabase database;
    private final MongoCollection<Document> players;
    private final MongoCollection<Document> logEntries;

    public LoggerRepositoryMongo(MongoDatabase database) {
        this.database = database;
        this.players = database.getCollection(StellarProtect.getInstance().getConfigManager().getTablesPlayers());
        this.logEntries = database.getCollection(StellarProtect.getInstance().getConfigManager().getTablesLogEntries());
    }

    @Override
    public void clearOldLogs() {
        Debugger.debugLog("Clearing old logs...");
        this.stellarProtect.getExecutor().execute(() -> {
            int daysToKeep = this.stellarProtect.getConfigManager().getDaysToKeepLogs();
            long cutoffTime = System.currentTimeMillis() - (long)daysToKeep * 24L * 60L * 60L * 1000L;
            Bson filter = Filters.lt("created_at", cutoffTime);
            DeleteResult result = this.logEntries.deleteMany(filter);
            Debugger.debugLog("Cleared " + result.getDeletedCount() + " logs from database.");
        });
    }

    @Override
    public void save(List<LogEntry> logEntries) {
        if (logEntries.isEmpty()) {
            return;
        }
        long start = System.currentTimeMillis();
        Debugger.debugSave("Saving log entries...");
        this.stellarProtect.getExecutor().execute(() -> {
            try {
                ArrayList<InsertOneModel<Document>> playerOps = new ArrayList<InsertOneModel<Document>>(logEntries.size());
                for (LogEntry logEntry : logEntries) {
                    String extraJson = logEntry.toSaveJson();
                    Document doc = new Document("id", logEntry.getId()).append("world_id", logEntry.getWorldId()).append("player_id", logEntry.getPlayerId()).append("x", logEntry.getX()).append("y", logEntry.getY()).append("z", logEntry.getZ()).append("action_type", logEntry.getActionType()).append("restored", logEntry.getRestored()).append("extra_json", extraJson).append("created_at", logEntry.getCreatedAt());
                    playerOps.add(new InsertOneModel<Document>(doc));
                }
                BulkWriteOptions options = new BulkWriteOptions().ordered(false).bypassDocumentValidation(true);
                BulkWriteResult result = this.logEntries.bulkWrite(playerOps, options);
                Debugger.debugSave("Saved " + result.getInsertedCount() + " log entries in " + (System.currentTimeMillis() - start) + "ms");
            }
            catch (Exception e) {
                Debugger.debugSave("Failed to save log entries. Trying again...");
            }
        });
    }

    @Override
    public void update(List<LogEntry> logEntries) {
        long start = System.currentTimeMillis();
        Debugger.debugSave("Updating log entries...");
        this.stellarProtect.getExecutor().execute(() -> {
            try {
                ArrayList<ReplaceOneModel<Document>> playerOps = new ArrayList<ReplaceOneModel<Document>>(logEntries.size());
                for (LogEntry playerLog : logEntries) {
                    playerOps.add(new ReplaceOneModel<Document>(new Document("id", playerLog.getId()), new Document("id", playerLog.getId()).append("restored", playerLog.getRestored())));
                }
                BulkWriteOptions options = new BulkWriteOptions().ordered(false).bypassDocumentValidation(true);
                BulkWriteResult result = this.logEntries.bulkWrite(playerOps, options);
                Debugger.debugSave("Updated " + result.getMatchedCount() + " log entries in " + (System.currentTimeMillis() - start) + "ms");
            }
            catch (Exception e) {
                Debugger.debugSave("Failed to update log entries. Trying again...");
            }
        });
    }

    @Override
    public void purgeLogs(@NonNull DatabaseFilters databaseFilters, Consumer<Long> onFinished) {
        if (databaseFilters == null) {
            throw new NullPointerException("databaseFilters is marked non-null but is null");
        }
        long start = System.currentTimeMillis();
        Debugger.debugSave("Purging logs...");
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024)));
        executor.execute(() -> {
            TimeArg timeArg = databaseFilters.getTimeFilter();
            RadiusArg radiusArg = databaseFilters.getRadiusFilter();
            UsersArg usersArg = databaseFilters.getUserFilters();
            List<Integer> actionTypes = databaseFilters.getActionTypesFilter();
            ArrayList<Bson> filters = new ArrayList<Bson>();
            if (timeArg != null) {
                filters.add(Filters.gte("created_at", timeArg.getStart()));
                filters.add(Filters.lte("created_at", timeArg.getEnd()));
            }
            if (radiusArg != null) {
                filters.add(Filters.gte("x", radiusArg.getMinX()));
                filters.add(Filters.lte("x", radiusArg.getMaxX()));
                filters.add(Filters.gte("y", radiusArg.getMinY()));
                filters.add(Filters.lte("y", radiusArg.getMaxY()));
                filters.add(Filters.gte("z", radiusArg.getMinZ()));
                filters.add(Filters.lte("z", radiusArg.getMaxZ()));
            }
            if (usersArg != null && usersArg.getUserIds() != null && !usersArg.getUserIds().isEmpty()) {
                filters.add(Filters.in("player_id", usersArg.getUserIds()));
            }
            if (actionTypes != null && !actionTypes.isEmpty()) {
                filters.add(Filters.in("action_type", actionTypes));
            }
            if (filters.isEmpty()) {
                Debugger.debugSave("No filters provided for purge operation. Skipping for safety.");
                return;
            }
            Bson filter = Filters.and(filters);
            DeleteResult result = this.logEntries.deleteMany(filter);
            long ms = System.currentTimeMillis() - start;
            if (result.getDeletedCount() > 0L) {
                Debugger.debugSave("Purged " + result.getDeletedCount() + " logs in " + ms + "ms");
            } else {
                Debugger.debugSave("No logs found to delete.");
            }
            onFinished.accept(ms);
        });
        executor.shutdown();
    }

    @Override
    public CompletableFuture<CallbackLookup<List<ItemLogEntry>, Long>> getChestTransactions(@NonNull Location location, int skip, int limit) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        return CompletableFuture.supplyAsync(() -> {
            List cachedLogs = LoggerCache.getChestTransactions(location, 0, Integer.MAX_VALUE).stream().filter(log -> System.currentTimeMillis() - log.getCreatedAt() <= TimeUnit.MINUTES.toMillis(15L)).sorted(Comparator.comparingLong(ItemLogEntry::getCreatedAt).reversed()).collect(Collectors.toList());
            List paginatedCachedLogs = cachedLogs.stream().skip(skip).limit(limit).collect(Collectors.toList());
            LinkedList result = new LinkedList(paginatedCachedLogs);
            int remaining = limit - paginatedCachedLogs.size();
            if (remaining > 0) {
                int effectiveSkipForDB = Math.max(0, skip - cachedLogs.size());
                int processedItemFromDB = 0;
                Set cachedItemKeys = cachedLogs.stream().map(ItemLogEntry::getItemStack).filter(Objects::nonNull).map(this::createItemKey).collect(Collectors.toSet());
                int addedFromDB = 0;
                int blockStart = 0;
                int blockSize = Math.max(10, remaining);
                long totalDBLogs = 0L;
                boolean hasMoreBlocks = true;
                while (addedFromDB < remaining && hasMoreBlocks) {
                    CallbackLookup<Set<LogEntry>, Long> dbLookup = this.queryLogsFromDB(location, blockStart, blockSize, ActionType.INVENTORY_TRANSACTION);
                    List dbLogs = dbLookup.getLogs().stream().filter(PlayerTransactionEntry.class::isInstance).sorted(Comparator.comparingLong(LogEntry::getCreatedAt).reversed()).collect(Collectors.toList());
                    if (dbLogs.isEmpty()) break;
                    int itemsAddedInThisBlock = 0;
                    block1: for (LogEntry log2 : dbLogs) {
                        String itemKey;
                        ItemStack item;
                        ItemTemplate itemTemplate;
                        PlayerTransactionEntry transaction = (PlayerTransactionEntry)log2;
                        if (addedFromDB >= remaining) {
                            totalDBLogs += (long)(transaction.getAdded().size() + transaction.getRemoved().size());
                            break;
                        }
                        totalDBLogs += (long)(transaction.getAdded().size() + transaction.getRemoved().size());
                        for (Map.Entry<Long, Integer> addedEntry : transaction.getAdded().entrySet()) {
                            if (++processedItemFromDB <= effectiveSkipForDB) continue;
                            if (addedFromDB >= remaining) break;
                            itemTemplate = this.stellarProtect.getItemsManager().getItemTemplate(addedEntry.getKey());
                            item = itemTemplate.getBukkitItem();
                            if (item == null || cachedItemKeys.contains(itemKey = this.createItemKey(item))) continue;
                            result.add(new ItemLogEntry(item, log2.getPlayerId(), addedEntry.getValue(), true, log2.getCreatedAt()));
                            ++addedFromDB;
                            ++itemsAddedInThisBlock;
                        }
                        for (Map.Entry<Long, Integer> removedEntry : transaction.getRemoved().entrySet()) {
                            if (++processedItemFromDB <= effectiveSkipForDB) continue;
                            if (addedFromDB >= remaining) continue block1;
                            itemTemplate = this.stellarProtect.getItemsManager().getItemTemplate(removedEntry.getKey());
                            item = itemTemplate.getBukkitItem();
                            if (item == null || cachedItemKeys.contains(itemKey = this.createItemKey(item))) continue;
                            result.add(new ItemLogEntry(item, log2.getPlayerId(), removedEntry.getValue(), false, log2.getCreatedAt()));
                            ++addedFromDB;
                            ++itemsAddedInThisBlock;
                        }
                    }
                    if (itemsAddedInThisBlock == 0 && addedFromDB < remaining) {
                        if ((long)((blockStart += blockSize) + blockSize) < totalDBLogs) continue;
                        hasMoreBlocks = false;
                        continue;
                    }
                    if (addedFromDB < remaining && dbLogs.size() == blockSize) {
                        if ((long)(blockStart += blockSize) < totalDBLogs) continue;
                        hasMoreBlocks = false;
                        continue;
                    }
                    hasMoreBlocks = false;
                }
                long estimatedTotalCount = (long)cachedLogs.size() + totalDBLogs;
                return new CallbackLookup(result, estimatedTotalCount);
            }
            return new CallbackLookup(result, Long.valueOf(cachedLogs.size()));
        }, (Executor)this.stellarProtect.getLookupExecutor());
    }

    private String createItemKey(ItemStack item) {
        return item.getType() + ":" + item.getDurability() + ":" + (item.hasItemMeta() ? item.getItemMeta().toString() : "null");
    }

    @Override
    public CompletableFuture<CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long>> getLogs(@NonNull DatabaseFilters databaseFilters, boolean ignoreCache, int skip, int limit) {
        if (databaseFilters == null) {
            throw new NullPointerException("databaseFilters is marked non-null but is null");
        }
        return CompletableFuture.supplyAsync(() -> {
            List cachedLogs = ignoreCache ? Collections.emptyList() : LoggerCache.getLogs(databaseFilters, skip, limit).stream().sorted(Comparator.comparingLong(LogEntry::getCreatedAt).reversed()).collect(Collectors.toList());
            Map groupedResults = cachedLogs.stream().collect(Collectors.groupingBy(LocationCache::of, LinkedHashMap::new, Collectors.toCollection(LinkedHashSet::new)));
            int remaining = limit - cachedLogs.size();
            if (remaining > 0) {
                int dbSkip = skip + cachedLogs.size();
                CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long> dbLookup = this.queryLogsFromDB(databaseFilters, dbSkip, remaining);
                List dbLogs = dbLookup.getLogs().values().stream().flatMap(Collection::stream).filter(log -> cachedLogs.stream().noneMatch(c -> c.equals(log))).sorted(Comparator.comparingLong(LogEntry::getCreatedAt).reversed()).limit(remaining).collect(Collectors.toList());
                Map dbGrouped = dbLogs.stream().collect(Collectors.groupingBy(LocationCache::of, LinkedHashMap::new, Collectors.toCollection(LinkedHashSet::new)));
                dbGrouped.forEach((location, logs) -> groupedResults.merge(location, logs, (existing, newLogs) -> {
                    existing.addAll(newLogs);
                    return existing;
                }));
                return new CallbackLookup<Map, Long>(groupedResults, dbLookup.getTotal());
            }
            long total = this.countLogs(databaseFilters);
            return new CallbackLookup<Map, Long>(groupedResults, total);
        }, (Executor)this.stellarProtect.getLookupExecutor());
    }

    @Override
    public CompletableFuture<CallbackLookup<Set<LogEntry>, Long>> getLogs(@NonNull Location location, int skip, int limit) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        return CompletableFuture.supplyAsync(() -> {
            List cachedLogs = LoggerCache.getLogs(LocationCache.of(location), skip, limit).stream().filter(log -> System.currentTimeMillis() - log.getCreatedAt() <= TimeUnit.MINUTES.toMillis(15L)).sorted(Comparator.comparingLong(LogEntry::getCreatedAt).reversed()).collect(Collectors.toList());
            LinkedHashSet result = new LinkedHashSet(cachedLogs);
            int remaining = limit - cachedLogs.size();
            if (remaining > 0) {
                int dbSkip = skip + cachedLogs.size();
                CallbackLookup<Set<LogEntry>, Long> dbLookup = this.queryLogsFromDB(location, dbSkip, remaining, null);
                List dbLogs = dbLookup.getLogs().stream().filter(log -> cachedLogs.stream().noneMatch(c -> c.equals(log))).sorted(Comparator.comparingLong(LogEntry::getCreatedAt).reversed()).limit(remaining).collect(Collectors.toList());
                result.addAll(dbLogs);
                return new CallbackLookup(result, dbLookup.getTotal());
            }
            return new CallbackLookup(result, (long)skip + (long)cachedLogs.size());
        }, (Executor)this.stellarProtect.getLookupExecutor());
    }

    private CallbackLookup<Set<LogEntry>, Long> queryLogsFromDB(Location location, int skip, int limit, @Nullable ActionType actionType) {
        LinkedHashSet<LogEntry> logs = new LinkedHashSet<LogEntry>();
        MongoCollection<Document> logCollection = this.logEntries;
        long now = System.currentTimeMillis();
        long startTime = now - TimeUnit.DAYS.toMillis(30L);
        Bson filter = Filters.and(Filters.gte("created_at", startTime), Filters.lte("created_at", now), Filters.eq("x", location.getBlockX()), Filters.eq("y", location.getBlockY()), Filters.eq("z", location.getBlockZ()));
        if (actionType != null) {
            filter = Filters.and(filter, Filters.eq("action_type", actionType.getId()));
        }
        long total = logCollection.countDocuments(filter);
        FindIterable<Document> logDocs = logCollection.find(filter).sort(Sorts.descending("created_at")).skip(skip).limit(limit);
        for (Document doc : logDocs) {
            long playerId = doc.getLong("player_id");
            Document playerDoc = (Document)this.players.find(Filters.eq("id", playerId)).first();
            if (playerDoc != null) {
                String playerName = playerDoc.getString("name");
                PlayerCache.cacheName(playerId, playerName);
            }
            try {
                LogEntry entry = LogEntryFactory.fromDocument(doc);
                logs.add(entry);
            }
            catch (Exception e) {
                Debugger.debugLog("Error al convertir LogEntry: " + doc.toJson());
            }
        }
        return new CallbackLookup<Set<LogEntry>, Long>(logs, total);
    }

    private CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long> queryLogsFromDB(DatabaseFilters databaseFilters, int skip, int limit) {
        Bson filter = this.buildFilters(databaseFilters);
        long totalCount = this.countLogs(databaseFilters);
        Set<LogEntry> logs = this.executeLogQuery(filter, skip, limit);
        Debugger.debugLog("Loaded " + logs.size() + " logs from MongoDB. Total count: " + totalCount);
        Map groupedLogs = logs.stream().collect(Collectors.groupingBy(LocationCache::of, LinkedHashMap::new, Collectors.toCollection(LinkedHashSet::new)));
        return new CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long>(groupedLogs, totalCount);
    }

    public long countLogs(DatabaseFilters databaseFilters) {
        Bson filter = this.buildFilters(databaseFilters);
        return this.countLogsWithPlayerValidation(filter);
    }

    private Bson buildFilters(DatabaseFilters databaseFilters) {
        TimeArg timeArg = databaseFilters.getTimeFilter();
        RadiusArg radiusArg = databaseFilters.getRadiusFilter();
        UsersArg usersArg = databaseFilters.getUserFilters();
        List<Integer> actionTypes = databaseFilters.getActionTypesFilter();
        List<Long> wordsFilter = databaseFilters.getAllIncludeFilters();
        List<Long> wordsExcludeFilter = databaseFilters.getAllExcludeFilters();
        ArrayList<Bson> filters = new ArrayList<Bson>();
        if (timeArg != null) {
            filters.add(Filters.gte("created_at", timeArg.getStart()));
            filters.add(Filters.lte("created_at", timeArg.getEnd()));
        }
        if (radiusArg != null) {
            if (radiusArg.getWorldId() != -1) {
                filters.add(Filters.eq("world_id", radiusArg.getWorldId()));
            }
            filters.add(Filters.gte("x", radiusArg.getMinX()));
            filters.add(Filters.lte("x", radiusArg.getMaxX()));
            filters.add(Filters.gte("y", radiusArg.getMinY()));
            filters.add(Filters.lte("y", radiusArg.getMaxY()));
            filters.add(Filters.gte("z", radiusArg.getMinZ()));
            filters.add(Filters.lte("z", radiusArg.getMaxZ()));
        }
        if (usersArg != null && usersArg.getUserIds() != null && !usersArg.getUserIds().isEmpty()) {
            filters.add(Filters.in("player_id", usersArg.getUserIds()));
        }
        if (actionTypes != null && !actionTypes.isEmpty()) {
            filters.add(Filters.in("action_type", actionTypes));
        }
        if (wordsFilter != null && !wordsFilter.isEmpty()) {
            filters.add(this.buildWordsIncludeFilter(wordsFilter));
        }
        if (wordsExcludeFilter != null && !wordsExcludeFilter.isEmpty()) {
            filters.add(this.buildWordsExcludeFilter(wordsExcludeFilter));
        }
        return filters.isEmpty() ? new Document() : Filters.and(filters);
    }

    private Bson buildWordsIncludeFilter(List<Long> worldsFilter) {
        if (worldsFilter.size() == 1) {
            Long worldId = worldsFilter.get(0);
            return Filters.text("\"id\":" + worldId + " OR \"ai\":{\"" + worldId + "\" OR \"ri\":{\"" + worldId + "\"");
        }
        ArrayList<Bson> worldConditions = new ArrayList<Bson>();
        for (Long worldId : worldsFilter) {
            worldConditions.add(Filters.text("\"id\":" + worldId + " OR \"ai\":{\"" + worldId + "\" OR \"ri\":{\"" + worldId + "\""));
        }
        return Filters.or(worldConditions);
    }

    private Bson buildWordsExcludeFilter(List<Long> worldsExcludeFilter) {
        ArrayList<Bson> excludeConditions = new ArrayList<Bson>();
        for (Long wordId : worldsExcludeFilter) {
            ArrayList<Bson> singleWorldExcludeConditions = new ArrayList<Bson>();
            singleWorldExcludeConditions.add(Filters.not(Filters.regex("extra_json", ".*\"id\"\\s*:\\s*\"?" + wordId + "\"?\\s*[,}].*")));
            singleWorldExcludeConditions.add(Filters.not(Filters.regex("extra_json", ".*\"ai\"\\s*:\\s*\\{[^}]*\"" + wordId + "\"\\s*:\\s*\\d+.*")));
            singleWorldExcludeConditions.add(Filters.not(Filters.regex("extra_json", ".*\"ri\"\\s*:\\s*\\{[^}]*\"" + wordId + "\"\\s*:\\s*\\d+.*")));
            excludeConditions.add(Filters.and(singleWorldExcludeConditions));
        }
        return excludeConditions.size() == 1 ? (Bson)excludeConditions.get(0) : Filters.and(excludeConditions);
    }

    private Set<LogEntry> executeLogQuery(Bson filter, int skip, int limit) {
        LinkedHashSet<LogEntry> logs = new LinkedHashSet<LogEntry>();
        FindIterable<Document> logDocs = this.logEntries.find(filter).sort(Sorts.descending("created_at")).skip(skip).limit(limit);
        for (Document doc : logDocs) {
            try {
                long playerId = doc.getLong("player_id");
                Document playerDoc = (Document)this.players.find(Filters.eq("id", playerId)).first();
                if (playerDoc != null) {
                    String playerName = playerDoc.getString("name");
                    PlayerCache.cacheName(playerId, playerName);
                } else {
                    Debugger.debugLog("Warning: Log entry has player_id " + playerId + " but player not found");
                }
                LogEntry entry = LogEntryFactory.fromDocument(doc);
                logs.add(entry);
            }
            catch (Exception e) {
                Debugger.debugLog("Error loading log: " + doc.toJson() + " - " + e.getMessage());
            }
        }
        return logs;
    }

    private long countLogsWithPlayerValidation(Bson filter) {
        try {
            List<Bson> pipeline = Arrays.asList(Aggregates.match(filter), Aggregates.lookup("players", "player_id", "id", "player_info"), Aggregates.match(Filters.ne("player_info", Collections.emptyList())), Aggregates.count("total"));
            AggregateIterable<Document> result = this.logEntries.aggregate(pipeline);
            Document countDoc = (Document)result.first();
            return countDoc != null ? (long)countDoc.getInteger("total", 0) : 0L;
        }
        catch (Exception e) {
            Debugger.debugLog("Error in aggregation count, falling back to simple count: " + e.getMessage());
            return this.logEntries.countDocuments(filter);
        }
    }
}

