/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.database.types.mongo;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.database.repositories.ItemsRepository;
import io.github.insideranh.stellarprotect.items.ItemTemplate;
import io.github.insideranh.stellarprotect.libs.bson.Document;
import io.github.insideranh.stellarprotect.libs.bson.conversions.Bson;
import io.github.insideranh.stellarprotect.libs.mongodb.bulk.BulkWriteResult;
import io.github.insideranh.stellarprotect.libs.mongodb.client.MongoCollection;
import io.github.insideranh.stellarprotect.libs.mongodb.client.MongoDatabase;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.Aggregates;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.BulkWriteOptions;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.Filters;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.Projections;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.ReplaceOneModel;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.ReplaceOptions;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.Sorts;
import io.github.insideranh.stellarprotect.utils.Debugger;
import io.github.insideranh.stellarprotect.utils.InventorySerializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.bukkit.inventory.ItemStack;

public class ItemsRepositoryMongo
implements ItemsRepository {
    private final StellarProtect stellarProtect = StellarProtect.getInstance();
    private final MongoDatabase database;
    private final MongoCollection<Document> item_templates;

    public ItemsRepositoryMongo(MongoDatabase database) {
        this.database = database;
        this.item_templates = database.getCollection(StellarProtect.getInstance().getConfigManager().getTablesItemTemplates());
    }

    @Override
    public void saveItems(List<ItemTemplate> itemTemplates) {
        this.stellarProtect.getExecutor().execute(() -> {
            try {
                ArrayList<Document> documents = new ArrayList<Document>();
                for (Object template : itemTemplates) {
                    if (template == null) continue;
                    Document doc = new Document().append("_id", ((ItemTemplate)template).getId()).append("base64", ((ItemTemplate)template).getBase64()).append("s", 0).append("access_count", 0).append("last_accessed", new Date()).append("total_quantity_used", 0).append("created_at", new Date());
                    documents.add(doc);
                }
                ArrayList<ReplaceOneModel<Document>> operations = new ArrayList<ReplaceOneModel<Document>>();
                for (Document doc : documents) {
                    ReplaceOneModel<Document> replaceModel = new ReplaceOneModel<Document>(Filters.eq("_id", doc.get("_id")), doc, new ReplaceOptions().upsert(true));
                    operations.add(replaceModel);
                }
                BulkWriteOptions bulkWriteOptions = new BulkWriteOptions().ordered(false).bypassDocumentValidation(false);
                int batchSize = 1000;
                int totalProcessed = 0;
                for (int i = 0; i < operations.size(); i += batchSize) {
                    int endIndex = Math.min(i + batchSize, operations.size());
                    List batch = operations.subList(i, endIndex);
                    BulkWriteResult result = this.item_templates.bulkWrite(batch, bulkWriteOptions);
                    Debugger.debugSave("Processed MongoDB: " + (totalProcessed += batch.size()) + "/" + operations.size() + " item templates " + result.getModifiedCount());
                }
                Debugger.debugSave("Saved " + itemTemplates.size() + " item templates in MongoDB");
            }
            catch (Exception e) {
                Debugger.debugSave("Error on save items in MongoDB: " + e.getMessage());
                e.printStackTrace();
            }
        });
    }

    @Override
    public void loadMostUsedItems() {
        try {
            List<Bson> pipeline = Arrays.asList(Aggregates.sort(Sorts.orderBy(Sorts.descending("access_count"), Sorts.descending("total_quantity_used"))), Aggregates.project(Projections.fields(Projections.include("_id", "base64", "s", "access_count", "last_accessed", "total_quantity_used", "created_at"))));
            try (Iterator cursor = this.item_templates.aggregate(pipeline).iterator();){
                while (cursor.hasNext()) {
                    Document doc = (Document)cursor.next();
                    long id = doc.getLong("_id");
                    String base64 = doc.getString("base64");
                    ItemStack bukkitItem = InventorySerializable.itemStackFromBase64(base64);
                    ItemTemplate template = new ItemTemplate(id, bukkitItem, base64);
                    this.stellarProtect.getItemsManager().loadItemReference(template, base64);
                }
            }
            long count = this.stellarProtect.getItemsManager().getItemReferenceCount();
            this.stellarProtect.getItemsManager().getCurrentId().set(count + 1L);
            Debugger.debugLog("Loaded " + count + " item references.");
        }
        catch (Exception e) {
            this.stellarProtect.getLogger().info("Error en loadMostUsedItems: " + e.getMessage());
        }
    }
}

