/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.database.entries.players;

import com.google.gson.JsonObject;
import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.blocks.BlockTemplate;
import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.enums.ExtraDataType;
import io.github.insideranh.stellarprotect.libs.bson.Document;
import io.github.insideranh.stellarprotect.managers.BlocksManager;
import java.sql.ResultSet;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class PlayerBlockLogEntry
extends LogEntry {
    private static final BlocksManager blocksManager = StellarProtect.getInstance().getBlocksManager();
    private final int blockId;
    private int oldBlockId;
    private String nexoBlockId;
    private byte extraType;
    private String extraData;

    public PlayerBlockLogEntry(Document document, JsonObject jsonObject) {
        super(document);
        this.blockId = this.getBlockId(jsonObject);
        this.oldBlockId = this.getOldBlockId(jsonObject);
        if (jsonObject.has("nbId")) {
            this.nexoBlockId = jsonObject.get("nbId").getAsString();
        }
        if (jsonObject.has("xt")) {
            this.extraType = jsonObject.get("xt").getAsByte();
        }
        if (jsonObject.has("xd")) {
            this.extraData = jsonObject.get("xd").getAsString();
        }
    }

    public PlayerBlockLogEntry(ResultSet resultSet, JsonObject jsonObject) {
        super(resultSet);
        this.blockId = this.getBlockId(jsonObject);
        this.oldBlockId = this.getOldBlockId(jsonObject);
        if (jsonObject.has("nbId")) {
            this.nexoBlockId = jsonObject.get("nbId").getAsString();
        }
        if (jsonObject.has("xt")) {
            this.extraType = jsonObject.get("xt").getAsByte();
        }
        if (jsonObject.has("xd")) {
            this.extraData = jsonObject.get("xd").getAsString();
        }
    }

    public PlayerBlockLogEntry(long playerId, BlockState oldBlockState, BlockState newBlockState, ActionType actionType) {
        super(playerId, actionType.getId(), newBlockState.getLocation(), System.currentTimeMillis());
        BlockTemplate oldBlockTemplate = blocksManager.getBlockTemplate(oldBlockState);
        this.oldBlockId = oldBlockTemplate.getId();
        BlockTemplate blockTemplate = blocksManager.getBlockTemplate(newBlockState);
        this.blockId = blockTemplate.getId();
    }

    public PlayerBlockLogEntry(long playerId, BlockState blockState, ActionType actionType) {
        super(playerId, actionType.getId(), blockState.getLocation(), System.currentTimeMillis());
        BlockTemplate itemTemplate = blocksManager.getBlockTemplate(blockState);
        this.blockId = itemTemplate.getId();
    }

    public PlayerBlockLogEntry(long playerId, Location location, Block block, ActionType actionType) {
        super(playerId, actionType.getId(), location, System.currentTimeMillis());
        BlockTemplate itemTemplate = blocksManager.getBlockTemplate(block);
        this.blockId = itemTemplate.getId();
    }

    public PlayerBlockLogEntry(long playerId, Block block, ActionType actionType) {
        super(playerId, actionType.getId(), block.getLocation(), System.currentTimeMillis());
        BlockTemplate itemTemplate = blocksManager.getBlockTemplate(block);
        this.blockId = itemTemplate.getId();
        if (actionType.getId() != ActionType.BLOCK_PLACE.getId() && actionType.getId() != ActionType.BLOCK_BREAK.getId()) {
            return;
        }
        if (block.getState() instanceof InventoryHolder) {
            Inventory inventory = ((InventoryHolder)block.getState()).getInventory();
            JsonObject jsonObject = StellarProtect.getInstance().getChestTransactionTracker().getInventoryContent(inventory);
            this.extraType = ExtraDataType.INVENTORY_CONTENT.getId();
            this.extraData = jsonObject.toString();
        }
    }

    public PlayerBlockLogEntry(long playerId, Block block, ActionType actionType, String nexoBlockId) {
        super(playerId, actionType.getId(), block.getLocation(), System.currentTimeMillis());
        BlockTemplate itemTemplate = blocksManager.getBlockTemplate(block);
        this.blockId = itemTemplate.getId();
        this.nexoBlockId = "nexo:" + nexoBlockId;
    }

    public int getBlockId(JsonObject jsonObject) {
        if (jsonObject.has("b")) {
            return jsonObject.get("b").getAsInt();
        }
        if (!jsonObject.has("d")) {
            return -1;
        }
        String data = jsonObject.get("d").getAsString();
        BlockTemplate blockTemplate = blocksManager.getBlockTemplate(data);
        return blockTemplate.getId();
    }

    public int getOldBlockId(JsonObject jsonObject) {
        if (jsonObject.has("ob")) {
            return jsonObject.get("ob").getAsInt();
        }
        if (!jsonObject.has("od")) {
            return -1;
        }
        String data = jsonObject.get("od").getAsString();
        BlockTemplate blockTemplate = blocksManager.getBlockTemplate(data);
        return blockTemplate.getId();
    }

    @Override
    public String getDataString() {
        if (this.nexoBlockId != null) {
            return this.nexoBlockId;
        }
        BlockTemplate itemTemplate = blocksManager.getBlockTemplate(this.blockId);
        return itemTemplate.getDataBlock().getBlockDataString();
    }

    @Override
    public String toSaveJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("b", (Number)this.blockId);
        if (this.oldBlockId != 0) {
            jsonObject.addProperty("ob", (Number)this.oldBlockId);
        }
        if (this.nexoBlockId != null) {
            jsonObject.addProperty("nbId", this.nexoBlockId);
        }
        if (this.extraType != 0) {
            jsonObject.addProperty("xt", (Number)this.extraType);
        }
        if (this.extraData != null) {
            jsonObject.addProperty("xd", this.extraData);
        }
        return jsonObject.toString();
    }

    @Generated
    public int getBlockId() {
        return this.blockId;
    }

    @Generated
    public int getOldBlockId() {
        return this.oldBlockId;
    }

    @Generated
    public String getNexoBlockId() {
        return this.nexoBlockId;
    }

    @Generated
    public byte getExtraType() {
        return this.extraType;
    }

    @Generated
    public String getExtraData() {
        return this.extraData;
    }
}

