/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.atomic.AtomicInteger;

public class RollingAverage {
    private static final VarHandle BUFFER_HANDLE = MethodHandles.arrayElementVarHandle(long[].class);
    private final long[] buffer;
    private final AtomicInteger head = new AtomicInteger(0);
    private final AtomicInteger size = new AtomicInteger(0);

    public RollingAverage(int capacity) {
        this.buffer = new long[capacity];
    }

    public void add(long value) {
        int index = this.head.getAndUpdate(h -> (h + 1) % this.buffer.length);
        BUFFER_HANDLE.setRelease(this.buffer, index, value);
        if (this.size.get() < this.buffer.length) {
            this.size.updateAndGet(s -> s < this.buffer.length ? s + 1 : s);
        }
    }

    public double average() {
        int size = this.size.get();
        if (size == 0) {
            return 0.0;
        }
        double sum = 0.0;
        for (int i = 0; i < size; ++i) {
            sum += (double)BUFFER_HANDLE.getAcquire(this.buffer, i);
        }
        return sum / (double)size;
    }
}

