/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.imprex.orebfuscator.util.Version;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import net.imprex.orebfuscator.Orebfuscator;
import org.bukkit.plugin.PluginDescriptionFile;

public abstract class AbstractHttpService {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Version.class, (Object)new Version.Json()).create();
    public static final HttpClient HTTP = HttpClient.newHttpClient();
    protected final String userAgent;

    public AbstractHttpService(Orebfuscator orebfuscator) {
        PluginDescriptionFile plugin = orebfuscator.getDescription();
        this.userAgent = String.format("Imprex-Development/%s/%s", plugin.getName(), plugin.getVersion());
    }

    protected HttpRequest.Builder request(String url) {
        return HttpRequest.newBuilder(URI.create(url)).header("User-Agent", this.userAgent).header("Accept", "application/json");
    }

    protected static <T> HttpResponse.BodyHandler<Optional<T>> optionalJson(Class<T> target) {
        return responseInfo -> responseInfo.statusCode() == 200 ? HttpResponse.BodySubscribers.mapping(HttpResponse.BodySubscribers.ofInputStream(), inputStream -> {
            Optional<Object> optional;
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);
            try {
                optional = Optional.ofNullable(GSON.fromJson((Reader)reader, target));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("I/O while reading JSON", e);
                }
            }
            reader.close();
            return optional;
        }) : HttpResponse.BodySubscribers.replacing(Optional.empty());
    }
}

