/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator.proximity;

import dev.imprex.orebfuscator.config.OrebfuscatorConfig;
import dev.imprex.orebfuscator.config.api.ProximityConfig;
import dev.imprex.orebfuscator.util.BlockPos;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.imprex.orebfuscator.Orebfuscator;
import net.imprex.orebfuscator.OrebfuscatorCompatibility;
import net.imprex.orebfuscator.OrebfuscatorNms;
import net.imprex.orebfuscator.iterop.BukkitWorldAccessor;
import net.imprex.orebfuscator.player.OrebfuscatorPlayer;
import net.imprex.orebfuscator.player.OrebfuscatorPlayerChunk;
import net.imprex.orebfuscator.player.OrebfuscatorPlayerMap;
import net.imprex.orebfuscator.util.FastGazeUtil;
import net.imprex.orebfuscator.util.PermissionUtil;
import net.imprex.shaded.org.joml.FrustumIntersection;
import net.imprex.shaded.org.joml.Quaternionf;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class ProximityWorker {
    private final OrebfuscatorConfig config;
    private final OrebfuscatorPlayerMap playerMap;

    public ProximityWorker(Orebfuscator orebfuscator) {
        this.config = orebfuscator.getOrebfuscatorConfig();
        this.playerMap = orebfuscator.getPlayerMap();
    }

    private boolean shouldIgnorePlayer(Player player) {
        if (PermissionUtil.canBypassObfuscate((Permissible)player)) {
            return true;
        }
        return player.getGameMode() == GameMode.SPECTATOR && this.config.general().ignoreSpectator();
    }

    protected void process(List<Player> players) {
        for (Player player : players) {
            try {
                this.process(player);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void process(Player player) {
        if (this.shouldIgnorePlayer(player)) {
            return;
        }
        World world = player.getWorld();
        BukkitWorldAccessor worldAccessor = BukkitWorldAccessor.get(world);
        ProximityConfig proximityConfig = this.config.world(worldAccessor).proximity();
        if (proximityConfig == null || !proximityConfig.isEnabled()) {
            return;
        }
        boolean needsRotation = proximityConfig.frustumCullingEnabled() || proximityConfig.rayCastCheckEnabled();
        OrebfuscatorPlayer orebfuscatorPlayer = this.playerMap.get(player);
        if (orebfuscatorPlayer == null || !orebfuscatorPlayer.needsProximityUpdate(needsRotation)) {
            return;
        }
        int distance = proximityConfig.distance();
        int distanceSquared = distance * distance;
        ArrayList<BlockPos> updateBlocks = new ArrayList<BlockPos>();
        Location eyeLocation = needsRotation ? player.getEyeLocation() : null;
        FrustumIntersection frustum = proximityConfig.frustumCullingEnabled() ? new FrustumIntersection(proximityConfig.frustumCullingProjectionMatrix().rotate(new Quaternionf().rotateX((float)Math.toRadians(eyeLocation.getPitch())).rotateY((float)Math.toRadians(eyeLocation.getYaw() + 180.0f))).translate((float)(-eyeLocation.getX()), (float)(-eyeLocation.getY()), (float)(-eyeLocation.getZ())), false) : null;
        Location location = player.getLocation();
        int minChunkX = location.getBlockX() - distance >> 4;
        int maxChunkX = location.getBlockX() + distance >> 4;
        int minChunkZ = location.getBlockZ() - distance >> 4;
        int maxChunkZ = location.getBlockZ() + distance >> 4;
        for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
            for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
                OrebfuscatorPlayerChunk chunk = orebfuscatorPlayer.getChunk(chunkX, chunkZ);
                if (chunk == null) continue;
                Iterator<BlockPos> iterator = chunk.proximityIterator();
                while (iterator.hasNext()) {
                    int result;
                    BlockPos blockPos = iterator.next();
                    double blockDistanceSquared = blockPos.distanceSquared(location.getX(), location.getY(), location.getZ());
                    if (blockDistanceSquared > (double)distanceSquared || proximityConfig.frustumCullingEnabled() && blockDistanceSquared > (double)proximityConfig.frustumCullingMinDistanceSquared() && (result = frustum.intersectAab(blockPos.x(), blockPos.y(), blockPos.z(), blockPos.x() + 1, blockPos.y() + 1, blockPos.z() + 1)) != -2 && result != -1 || proximityConfig.rayCastCheckEnabled() && !FastGazeUtil.doFastCheck(blockPos, eyeLocation, world, proximityConfig.rayCastCheckOnlyCheckCenter())) continue;
                    iterator.remove();
                    updateBlocks.add(blockPos);
                }
                if (!chunk.isEmpty()) continue;
                orebfuscatorPlayer.removeChunk(chunkX, chunkZ);
            }
        }
        OrebfuscatorCompatibility.runForPlayer(player, () -> {
            if (player.isOnline() && player.getWorld().equals((Object)world)) {
                OrebfuscatorNms.sendBlockUpdates(player, (Iterable<BlockPos>)updateBlocks);
            }
        });
    }
}

