/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator.player;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.imprex.orebfuscator.Orebfuscator;
import net.imprex.orebfuscator.player.OrebfuscatorPlayer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class OrebfuscatorPlayerMap
implements Listener {
    private final Orebfuscator orebfuscator;
    private final ConcurrentMap<Player, OrebfuscatorPlayer> internalMap = new ConcurrentHashMap<Player, OrebfuscatorPlayer>();

    public OrebfuscatorPlayerMap(Orebfuscator orebfuscator) {
        this.orebfuscator = orebfuscator;
        if (orebfuscator.getOrebfuscatorConfig().proximityEnabled()) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)orebfuscator);
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.addPlayer(player);
            }
        }
    }

    private void addPlayer(Player player) {
        this.internalMap.put(player, new OrebfuscatorPlayer(this.orebfuscator, player));
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        this.addPlayer(event.getPlayer());
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.internalMap.remove(event.getPlayer());
    }

    public OrebfuscatorPlayer get(Player player) {
        OrebfuscatorPlayer orebfuscatorPlayer = (OrebfuscatorPlayer)this.internalMap.get(player);
        if (orebfuscatorPlayer != null) {
            orebfuscatorPlayer.updateWorld();
        }
        return orebfuscatorPlayer;
    }
}

