/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator.player;

import dev.imprex.orebfuscator.util.BlockPos;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class OrebfuscatorPlayerChunk {
    private final int chunkX;
    private final int chunkZ;
    private int proximitySize;
    private final int[] proximityBlocks;

    public OrebfuscatorPlayerChunk(int chunkX, int chunkZ, List<BlockPos> proximityBlocks) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.proximitySize = proximityBlocks.size();
        this.proximityBlocks = new int[proximityBlocks.size()];
        for (int i = 0; i < proximityBlocks.size(); ++i) {
            this.proximityBlocks[i] = proximityBlocks.get(i).toSectionPos();
        }
    }

    public boolean isEmpty() {
        return this.proximitySize <= 0;
    }

    public Iterator<BlockPos> proximityIterator() {
        return new ProximityItr();
    }

    private class ProximityItr
    implements Iterator<BlockPos> {
        private final int x;
        private final int z;
        private int cursor;
        private int returnCursor;

        private ProximityItr() {
            this.x = OrebfuscatorPlayerChunk.this.chunkX << 4;
            this.z = OrebfuscatorPlayerChunk.this.chunkZ << 4;
            this.returnCursor = -1;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < OrebfuscatorPlayerChunk.this.proximitySize;
        }

        @Override
        public BlockPos next() {
            if (this.cursor >= OrebfuscatorPlayerChunk.this.proximitySize) {
                throw new NoSuchElementException();
            }
            this.returnCursor = this.cursor++;
            int sectionPos = OrebfuscatorPlayerChunk.this.proximityBlocks[this.returnCursor];
            return BlockPos.fromSectionPos(this.x, this.z, sectionPos);
        }

        @Override
        public void remove() {
            if (this.returnCursor < 0) {
                throw new IllegalStateException();
            }
            int newSize = OrebfuscatorPlayerChunk.this.proximitySize - 1;
            int index = this.returnCursor;
            if (newSize > index) {
                System.arraycopy(OrebfuscatorPlayerChunk.this.proximityBlocks, index + 1, OrebfuscatorPlayerChunk.this.proximityBlocks, index, newSize - index);
            }
            OrebfuscatorPlayerChunk.this.proximitySize = newSize;
            OrebfuscatorPlayerChunk.this.proximityBlocks[OrebfuscatorPlayerChunk.this.proximitySize] = -1;
            this.cursor = this.returnCursor;
            this.returnCursor = -1;
        }
    }
}

