/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator.player;

import com.google.common.base.Objects;
import dev.imprex.orebfuscator.config.api.AdvancedConfig;
import dev.imprex.orebfuscator.util.BlockPos;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import net.imprex.orebfuscator.Orebfuscator;
import net.imprex.orebfuscator.player.OrebfuscatorPlayerChunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class OrebfuscatorPlayer {
    private final Player player;
    private final AdvancedConfig config;
    private final AtomicReference<World> world = new AtomicReference();
    private final Map<Long, OrebfuscatorPlayerChunk> chunks = new ConcurrentHashMap<Long, OrebfuscatorPlayerChunk>();
    private volatile long latestUpdateTimestamp = System.currentTimeMillis();
    private volatile Location location = new Location(null, 0.0, 0.0, 0.0);

    private static long chunkCoordsToLong(int chunkX, int chunkZ) {
        return ((long)chunkZ & 0xFFFFFFFFL) << 32 | (long)chunkX & 0xFFFFFFFFL;
    }

    public OrebfuscatorPlayer(Orebfuscator orebfuscator, Player player) {
        this.player = player;
        this.config = orebfuscator.getOrebfuscatorConfig().advanced();
        this.location = player.getLocation();
    }

    public boolean needsProximityUpdate(boolean rotation) {
        if (!this.player.isOnline()) {
            return false;
        }
        long timestamp = System.currentTimeMillis();
        if (this.config.hasProximityPlayerCheckInterval() && timestamp - this.latestUpdateTimestamp > (long)this.config.proximityPlayerCheckInterval()) {
            this.location = this.location;
            this.latestUpdateTimestamp = timestamp;
            return true;
        }
        Location location = this.player.getLocation();
        if (OrebfuscatorPlayer.isLocationSimilar(rotation, this.location, location)) {
            return false;
        }
        this.location = location;
        this.latestUpdateTimestamp = timestamp;
        return true;
    }

    private static boolean isLocationSimilar(boolean rotation, Location a, Location b) {
        if (!Objects.equal((Object)a.getWorld(), (Object)b.getWorld())) {
            return false;
        }
        if (a.distanceSquared(b) > 0.25) {
            return false;
        }
        return !rotation || !(Math.abs(a.getYaw() - b.getYaw()) > 5.0f) && !((double)Math.abs(a.getPitch() - b.getPitch()) > 2.5);
    }

    void updateWorld() {
        if (!this.player.isOnline()) {
            return;
        }
        World world = this.player.getWorld();
        if (!Objects.equal((Object)this.world.getAndSet(world), (Object)world)) {
            this.chunks.clear();
        }
    }

    public void addChunk(int chunkX, int chunkZ, List<BlockPos> blocks) {
        this.chunks.put(OrebfuscatorPlayer.chunkCoordsToLong(chunkX, chunkZ), new OrebfuscatorPlayerChunk(chunkX, chunkZ, blocks));
    }

    public OrebfuscatorPlayerChunk getChunk(int chunkX, int chunkZ) {
        return this.chunks.get(OrebfuscatorPlayer.chunkCoordsToLong(chunkX, chunkZ));
    }

    public void removeChunk(int chunkX, int chunkZ) {
        this.chunks.remove(OrebfuscatorPlayer.chunkCoordsToLong(chunkX, chunkZ));
    }
}

