/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator.obfuscation;

import java.util.concurrent.atomic.AtomicInteger;
import net.imprex.orebfuscator.Orebfuscator;
import net.imprex.orebfuscator.obfuscation.ObfuscationProcessor;
import net.imprex.orebfuscator.obfuscation.ObfuscationTask;
import net.imprex.orebfuscator.obfuscation.ObfuscationTaskDispatcher;
import net.imprex.orebfuscator.util.RingTimer;

class ObfuscationTaskWorker
implements Runnable {
    private static final AtomicInteger WORKER_ID = new AtomicInteger();
    private final ObfuscationTaskDispatcher dispatcher;
    private final ObfuscationProcessor processor;
    private final Thread thread;
    private volatile boolean running = true;
    private final RingTimer waitTimer = new RingTimer(100);
    private final RingTimer processTimer = new RingTimer(100);

    public ObfuscationTaskWorker(ObfuscationTaskDispatcher dispatcher, ObfuscationProcessor processor) {
        this.dispatcher = dispatcher;
        this.processor = processor;
        this.thread = new Thread(Orebfuscator.THREAD_GROUP, this, "ofc-task-worker-" + WORKER_ID.getAndIncrement());
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public double waitTime() {
        return this.waitTimer.average();
    }

    public double processTime() {
        return this.processTimer.average();
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                ObfuscationTask task;
                this.waitTimer.start();
                try {
                    task = this.dispatcher.retrieveTask();
                }
                finally {
                    this.waitTimer.stop();
                }
                this.processTimer.start();
                try {
                    this.processor.process(task);
                }
                finally {
                    this.processTimer.stop();
                }
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public void shutdown() {
        this.running = false;
        this.thread.interrupt();
    }
}

