/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator.obfuscation;

import dev.imprex.orebfuscator.config.api.AdvancedConfig;
import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import net.imprex.orebfuscator.Orebfuscator;
import net.imprex.orebfuscator.OrebfuscatorStatistics;
import net.imprex.orebfuscator.obfuscation.ObfuscationProcessor;
import net.imprex.orebfuscator.obfuscation.ObfuscationRequest;
import net.imprex.orebfuscator.obfuscation.ObfuscationTask;
import net.imprex.orebfuscator.obfuscation.ObfuscationTaskWorker;

class ObfuscationTaskDispatcher {
    private static final long DEFAULT_PARK_DURATION = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final long MAX_PARK_DURATION = TimeUnit.MILLISECONDS.toNanos(16L);
    private final Queue<ObfuscationTask> tasks = new ConcurrentLinkedQueue<ObfuscationTask>();
    private final ObfuscationProcessor processor;
    private final ObfuscationTaskWorker[] worker;

    public ObfuscationTaskDispatcher(Orebfuscator orebfuscator, ObfuscationProcessor processor) {
        this.processor = processor;
        AdvancedConfig config = orebfuscator.getOrebfuscatorConfig().advanced();
        this.worker = new ObfuscationTaskWorker[config.obfuscationThreads()];
        for (int i = 0; i < this.worker.length; ++i) {
            this.worker[i] = new ObfuscationTaskWorker(this, this.processor);
        }
        OrebfuscatorStatistics statistics = orebfuscator.getStatistics();
        statistics.setObfuscationQueueLengthSupplier(() -> this.tasks.size());
        statistics.setObfuscationWaitTime(() -> (long)Arrays.stream(this.worker).mapToDouble(ObfuscationTaskWorker::waitTime).average().orElse(0.0));
        statistics.setObfuscationProcessTime(() -> (long)Arrays.stream(this.worker).mapToDouble(ObfuscationTaskWorker::processTime).average().orElse(0.0));
    }

    public void submitRequest(ObfuscationRequest request) {
        ObfuscationTask.fromRequest(request).whenComplete((task, throwable) -> {
            if (throwable != null) {
                request.completeExceptionally((Throwable)throwable);
            } else {
                this.tasks.offer((ObfuscationTask)task);
            }
        });
    }

    public ObfuscationTask retrieveTask() throws InterruptedException {
        ObfuscationTask task;
        long parkDuration = DEFAULT_PARK_DURATION;
        int i = 0;
        while ((task = this.tasks.poll()) == null) {
            if (i < 8192) {
                Thread.onSpinWait();
            } else {
                LockSupport.parkNanos(this, parkDuration);
                if (parkDuration < MAX_PARK_DURATION) {
                    parkDuration *= 2L;
                }
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            ++i;
        }
        return task;
    }

    public void shutdown() {
        for (ObfuscationTaskWorker worker : this.worker) {
            worker.shutdown();
        }
    }
}

