/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator.obfuscation;

import dev.imprex.orebfuscator.config.OrebfuscatorConfig;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.imprex.orebfuscator.Orebfuscator;
import net.imprex.orebfuscator.cache.ObfuscationCache;
import net.imprex.orebfuscator.iterop.BukkitChunkPacketAccessor;
import net.imprex.orebfuscator.obfuscation.DeobfuscationListener;
import net.imprex.orebfuscator.obfuscation.DeobfuscationWorker;
import net.imprex.orebfuscator.obfuscation.ObfuscationListener;
import net.imprex.orebfuscator.obfuscation.ObfuscationProcessor;
import net.imprex.orebfuscator.obfuscation.ObfuscationRequest;
import net.imprex.orebfuscator.obfuscation.ObfuscationResult;
import net.imprex.orebfuscator.obfuscation.ObfuscationTaskDispatcher;
import org.bukkit.block.Block;

public class ObfuscationSystem {
    private final Orebfuscator orebfuscator;
    private final OrebfuscatorConfig config;
    private final ObfuscationCache cache;
    private final ObfuscationProcessor processor;
    private final ObfuscationTaskDispatcher dispatcher;
    private ObfuscationListener listener;
    private final DeobfuscationWorker deobfuscationWorker;

    public ObfuscationSystem(Orebfuscator orebfuscator) {
        this.orebfuscator = orebfuscator;
        this.config = orebfuscator.getOrebfuscatorConfig();
        this.cache = orebfuscator.getObfuscationCache();
        this.processor = new ObfuscationProcessor(orebfuscator);
        this.dispatcher = new ObfuscationTaskDispatcher(orebfuscator, this.processor);
        this.deobfuscationWorker = new DeobfuscationWorker(orebfuscator);
        DeobfuscationListener.createAndRegister(orebfuscator, this.deobfuscationWorker);
    }

    public void registerChunkListener() {
        this.listener = new ObfuscationListener(this.orebfuscator);
    }

    public CompletableFuture<ObfuscationResult> obfuscate(BukkitChunkPacketAccessor packet) {
        ObfuscationRequest request = ObfuscationRequest.fromChunk(packet, this.config, this.dispatcher);
        if (this.config.cache().enabled()) {
            return this.cache.get(request);
        }
        return request.submitForObfuscation();
    }

    public void deobfuscate(Collection<? extends Block> blocks) {
        this.deobfuscationWorker.deobfuscate(blocks, false);
    }

    public void shutdown() {
        this.listener.unregister();
        this.dispatcher.shutdown();
    }
}

