/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator.obfuscation;

import dev.imprex.orebfuscator.chunk.Chunk;
import dev.imprex.orebfuscator.chunk.ChunkFactory;
import dev.imprex.orebfuscator.chunk.ChunkSection;
import dev.imprex.orebfuscator.config.OrebfuscatorConfig;
import dev.imprex.orebfuscator.config.ProximityHeightCondition;
import dev.imprex.orebfuscator.config.api.BlockFlags;
import dev.imprex.orebfuscator.config.api.ObfuscationConfig;
import dev.imprex.orebfuscator.config.api.ProximityConfig;
import dev.imprex.orebfuscator.config.api.WorldConfigBundle;
import dev.imprex.orebfuscator.util.BlockPos;
import java.util.ArrayList;
import java.util.HashSet;
import net.imprex.orebfuscator.Orebfuscator;
import net.imprex.orebfuscator.OrebfuscatorNms;
import net.imprex.orebfuscator.iterop.BukkitChunkPacketAccessor;
import net.imprex.orebfuscator.iterop.BukkitWorldAccessor;
import net.imprex.orebfuscator.obfuscation.ObfuscationTask;

public class ObfuscationProcessor {
    private final OrebfuscatorConfig config;
    private final ChunkFactory chunkFactory;

    public ObfuscationProcessor(Orebfuscator orebfuscator) {
        this.config = orebfuscator.getOrebfuscatorConfig();
        this.chunkFactory = orebfuscator.getChunkFactory();
    }

    public void process(ObfuscationTask task) {
        BukkitChunkPacketAccessor packet = task.getPacket();
        BukkitWorldAccessor worldAccessor = packet.worldAccessor;
        WorldConfigBundle bundle = this.config.world(worldAccessor);
        BlockFlags blockFlags = bundle.blockFlags();
        ObfuscationConfig obfuscationConfig = bundle.obfuscation();
        ProximityConfig proximityConfig = bundle.proximity();
        HashSet<BlockPos> blockEntities = new HashSet<BlockPos>();
        ArrayList<BlockPos> proximityBlocks = new ArrayList<BlockPos>();
        int baseX = packet.chunkX() << 4;
        int baseZ = packet.chunkZ() << 4;
        int layerY = Integer.MIN_VALUE;
        int layerYBlockState = -1;
        try (Chunk chunk = this.chunkFactory.fromPacket(packet);){
            for (int sectionIndex = Math.max(0, bundle.minSectionIndex()); sectionIndex <= Math.min(chunk.getSectionCount() - 1, bundle.maxSectionIndex()); ++sectionIndex) {
                ChunkSection chunkSection = chunk.getSection(sectionIndex);
                if (chunkSection == null || chunkSection.isEmpty()) continue;
                int baseY = worldAccessor.getMinBuildHeight() + (sectionIndex << 4);
                for (int index = 0; index < 4096; ++index) {
                    int blockState;
                    int obfuscateBits;
                    int y = baseY + (index >> 8 & 0xF);
                    if (!bundle.shouldObfuscate(y) || BlockFlags.isEmpty(obfuscateBits = blockFlags.flags(blockState = chunkSection.getBlockState(index), y))) continue;
                    int x = baseX + (index & 0xF);
                    int z = baseZ + (index >> 4 & 0xF);
                    boolean isObfuscateBitSet = BlockFlags.isObfuscateBitSet(obfuscateBits);
                    boolean obfuscated = false;
                    if (isObfuscateBitSet && obfuscationConfig.shouldObfuscate(y) && this.shouldObfuscate(task, chunk, x, y, z)) {
                        if (obfuscationConfig.layerObfuscation()) {
                            if (layerY != y) {
                                layerY = y;
                                layerYBlockState = bundle.nextRandomObfuscationBlock(y);
                            }
                            blockState = layerYBlockState;
                        } else {
                            blockState = bundle.nextRandomObfuscationBlock(y);
                        }
                        obfuscated = true;
                    }
                    if (!obfuscated && BlockFlags.isProximityBitSet(obfuscateBits) && proximityConfig.shouldObfuscate(y)) {
                        proximityBlocks.add(new BlockPos(x, y, z));
                        if (BlockFlags.isUseBlockBelowBitSet(obfuscateBits)) {
                            boolean allowNonOcclude = !isObfuscateBitSet || !ProximityHeightCondition.isPresent(obfuscateBits);
                            blockState = this.getBlockStateBelow(bundle, chunk, x, y, z, allowNonOcclude);
                        } else {
                            blockState = bundle.nextRandomProximityBlock(y);
                        }
                        obfuscated = true;
                    }
                    if (!obfuscated) continue;
                    chunkSection.setBlockState(index, blockState);
                    if (!BlockFlags.isBlockEntityBitSet(obfuscateBits)) continue;
                    blockEntities.add(new BlockPos(x, y, z));
                }
            }
            task.complete(chunk.finalizeOutput(), blockEntities, proximityBlocks);
        }
        catch (Exception e) {
            task.completeExceptionally(e);
        }
    }

    private int getBlockStateBelow(WorldConfigBundle bundle, Chunk chunk, int x, int y, int z, boolean allowNonOcclude) {
        BlockFlags blockFlags = bundle.blockFlags();
        for (int targetY = y - 1; targetY > chunk.world().getMinBuildHeight(); --targetY) {
            int mask;
            int blockData = chunk.getBlockState(x, targetY, z);
            if (blockData == -1 || !allowNonOcclude && !OrebfuscatorNms.isOccluding(blockData) || !BlockFlags.isEmpty(mask = blockFlags.flags(blockData, y)) && !BlockFlags.isAllowForUseBlockBelowBitSet(mask)) continue;
            return blockData;
        }
        return bundle.nextRandomProximityBlock(y);
    }

    private boolean shouldObfuscate(ObfuscationTask task, Chunk chunk, int x, int y, int z) {
        return this.isAdjacentBlockOccluding(task, chunk, x, y + 1, z) && this.isAdjacentBlockOccluding(task, chunk, x, y - 1, z) && this.isAdjacentBlockOccluding(task, chunk, x + 1, y, z) && this.isAdjacentBlockOccluding(task, chunk, x - 1, y, z) && this.isAdjacentBlockOccluding(task, chunk, x, y, z + 1) && this.isAdjacentBlockOccluding(task, chunk, x, y, z - 1);
    }

    private boolean isAdjacentBlockOccluding(ObfuscationTask task, Chunk chunk, int x, int y, int z) {
        if (y >= chunk.world().getMaxBuildHeight() || y < chunk.world().getMinBuildHeight()) {
            return false;
        }
        int blockId = chunk.getBlockState(x, y, z);
        if (blockId == -1) {
            blockId = task.getBlockState(x, y, z);
        }
        return blockId >= 0 && OrebfuscatorNms.isOccluding(blockId);
    }
}

