/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator.nms.v1_20_R1_mojang;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import dev.imprex.orebfuscator.cache.AbstractRegionFileCache;
import dev.imprex.orebfuscator.config.api.Config;
import dev.imprex.orebfuscator.util.BlockProperties;
import dev.imprex.orebfuscator.util.BlockStateProperties;
import dev.imprex.orebfuscator.util.BlockTag;
import dev.imprex.orebfuscator.util.NamespacedKey;
import it.unimi.dsi.fastutil.shorts.Short2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.imprex.orebfuscator.nms.AbstractNmsManager;
import net.imprex.orebfuscator.nms.ReadOnlyChunk;
import net.imprex.orebfuscator.nms.v1_20_R1_mojang.ReadOnlyChunkWrapper;
import net.imprex.orebfuscator.nms.v1_20_R1_mojang.RegionFileCache;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class NmsManager
extends AbstractNmsManager {
    private static final int BLOCK_ID_AIR = Block.getId((BlockState)Blocks.AIR.defaultBlockState());

    static int getBlockState(LevelChunk chunk, int x, int y, int z) {
        LevelChunkSection section;
        LevelChunkSection[] sections = chunk.getSections();
        int sectionIndex = chunk.getSectionIndex(y);
        if (sectionIndex >= 0 && sectionIndex < sections.length && (section = sections[sectionIndex]) != null && !section.hasOnlyAir()) {
            return Block.getId((BlockState)section.getBlockState(x & 0xF, y & 0xF, z & 0xF));
        }
        return BLOCK_ID_AIR;
    }

    private static ServerLevel level(World world) {
        return NmsManager.worldHandle(world, ServerLevel.class);
    }

    private static ServerPlayer player(Player player) {
        return NmsManager.playerHandle(player, ServerPlayer.class);
    }

    public NmsManager() {
        super(Block.BLOCK_STATE_REGISTRY.size());
        for (Map.Entry entry : BuiltInRegistries.BLOCK.entrySet()) {
            NamespacedKey namespacedKey = NamespacedKey.fromString(((ResourceKey)entry.getKey()).location().toString());
            Block block = (Block)entry.getValue();
            ImmutableList possibleBlockStates = block.getStateDefinition().getPossibleStates();
            BlockProperties.Builder builder = BlockProperties.builder(namespacedKey);
            for (BlockState blockState : possibleBlockStates) {
                BlockStateProperties properties = BlockStateProperties.builder(Block.getId((BlockState)blockState)).withIsAir(blockState.isAir()).withIsOccluding(blockState.isSolidRender((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO)).withIsBlockEntity(blockState.hasBlockEntity()).withIsDefaultState(Objects.equals(block.defaultBlockState(), blockState)).build();
                builder.withBlockState(properties);
            }
            this.registerBlockProperties(builder.build());
        }
        BuiltInRegistries.BLOCK.getTags().map(Pair::getSecond).forEach(tag -> {
            NamespacedKey namespacedKey = NamespacedKey.fromString(tag.key().location().toString());
            Set<BlockProperties> blocks = tag.stream().map(holder -> holder.unwrapKey().map(key -> this.getBlockByName(key.location().toString()))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toUnmodifiableSet());
            this.registerBlockTag(new BlockTag(namespacedKey, blocks));
        });
    }

    @Override
    public AbstractRegionFileCache<?> createRegionFileCache(Config config) {
        return new RegionFileCache(config.cache());
    }

    @Override
    public ReadOnlyChunk getReadOnlyChunk(World world, int chunkX, int chunkZ) {
        ServerChunkCache serverChunkCache = NmsManager.level(world).getChunkSource();
        LevelChunk chunk = serverChunkCache.getChunk(chunkX, chunkZ, true);
        return new ReadOnlyChunkWrapper(chunk);
    }

    @Override
    public int getBlockState(World world, int x, int y, int z) {
        ServerChunkCache serverChunkCache = NmsManager.level(world).getChunkSource();
        if (!serverChunkCache.isChunkLoaded(x >> 4, z >> 4)) {
            return BLOCK_ID_AIR;
        }
        LevelChunk chunk = serverChunkCache.getChunk(x >> 4, z >> 4, true);
        if (chunk == null) {
            return BLOCK_ID_AIR;
        }
        return NmsManager.getBlockState(chunk, x, y, z);
    }

    @Override
    public void sendBlockUpdates(World world, Iterable<dev.imprex.orebfuscator.util.BlockPos> iterable) {
        ServerChunkCache serverChunkCache = NmsManager.level(world).getChunkSource();
        BlockPos.MutableBlockPos position = new BlockPos.MutableBlockPos();
        for (dev.imprex.orebfuscator.util.BlockPos pos : iterable) {
            position.set(pos.x(), pos.y(), pos.z());
            serverChunkCache.blockChanged((BlockPos)position);
        }
    }

    @Override
    public void sendBlockUpdates(Player player, Iterable<dev.imprex.orebfuscator.util.BlockPos> iterable) {
        ServerPlayer serverPlayer = NmsManager.player(player);
        ServerLevel level = serverPlayer.serverLevel();
        ServerChunkCache serverChunkCache = level.getChunkSource();
        BlockPos.MutableBlockPos position = new BlockPos.MutableBlockPos();
        HashMap<SectionPos, Short2ObjectMap> sectionPackets = new HashMap<SectionPos, Short2ObjectMap>();
        ArrayList<Packet> blockEntityPackets = new ArrayList<Packet>();
        for (dev.imprex.orebfuscator.util.BlockPos blockPos : iterable) {
            BlockEntity blockEntity;
            if (!serverChunkCache.isChunkLoaded(blockPos.x() >> 4, blockPos.z() >> 4)) continue;
            position.set(blockPos.x(), blockPos.y(), blockPos.z());
            BlockState blockState = level.getBlockState((BlockPos)position);
            sectionPackets.computeIfAbsent(SectionPos.of((BlockPos)position), key -> new Short2ObjectLinkedOpenHashMap()).put(SectionPos.sectionRelativePos((BlockPos)position), (Object)blockState);
            if (!blockState.hasBlockEntity() || (blockEntity = level.getBlockEntity((BlockPos)position)) == null) continue;
            blockEntityPackets.add(blockEntity.getUpdatePacket());
        }
        for (Map.Entry entry : sectionPackets.entrySet()) {
            Short2ObjectMap blockStates = (Short2ObjectMap)entry.getValue();
            if (blockStates.size() == 1) {
                Short2ObjectMap.Entry blockEntry = (Short2ObjectMap.Entry)blockStates.short2ObjectEntrySet().iterator().next();
                BlockPos blockPosition = ((SectionPos)entry.getKey()).relativeToBlockPos(blockEntry.getShortKey());
                serverPlayer.connection.send((Packet)new ClientboundBlockUpdatePacket(blockPosition, (BlockState)blockEntry.getValue()));
                continue;
            }
            serverPlayer.connection.send((Packet)new ClientboundSectionBlocksUpdatePacket((SectionPos)entry.getKey(), blockStates.keySet(), (BlockState[])blockStates.values().toArray(BlockState[]::new)));
        }
        for (Packet packet : blockEntityPackets) {
            serverPlayer.connection.send(packet);
        }
    }
}

