/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator.iterop;

import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import dev.imprex.orebfuscator.interop.WorldAccessor;
import dev.imprex.orebfuscator.logging.OfcLogger;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.imprex.orebfuscator.util.MinecraftVersion;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;

public class BukkitWorldAccessor
implements WorldAccessor {
    private static final boolean HAS_DYNAMIC_HEIGHT = MinecraftVersion.isAtOrAbove("1.17");
    private static final Map<World, BukkitWorldAccessor> ACCESSOR_LOOKUP = new ConcurrentHashMap<World, BukkitWorldAccessor>();
    private static final MethodAccessor WORLD_GET_MAX_HEIGHT = BukkitWorldAccessor.getWorldMethod("getMaxHeight");
    private static final MethodAccessor WORLD_GET_MIN_HEIGHT = BukkitWorldAccessor.getWorldMethod("getMinHeight");
    public final World world;
    private final int maxHeight;
    private final int minHeight;

    public static BukkitWorldAccessor get(World world) {
        return ACCESSOR_LOOKUP.computeIfAbsent(world, key -> {
            OfcLogger.warn("Created world accessor outside of event!");
            return new BukkitWorldAccessor((World)key);
        });
    }

    private static MethodAccessor getWorldMethod(String methodName) {
        if (HAS_DYNAMIC_HEIGHT) {
            MethodAccessor methodAccessor = BukkitWorldAccessor.getWorldMethod0(World.class, methodName);
            if (methodAccessor == null) {
                throw new RuntimeException("unable to find method: World::" + methodName + "()");
            }
            OfcLogger.debug("HeightAccessor found method: World::" + methodName + "()");
            return methodAccessor;
        }
        return null;
    }

    private static MethodAccessor getWorldMethod0(Class<?> target, String methodName) {
        try {
            return Accessors.getMethodAccessor(target, (String)methodName, (Class[])new Class[0]);
        }
        catch (IllegalArgumentException e) {
            for (Class<?> iterface : target.getInterfaces()) {
                MethodAccessor methodAccessor = BukkitWorldAccessor.getWorldMethod0(iterface, methodName);
                if (methodAccessor == null) continue;
                return methodAccessor;
            }
            return null;
        }
    }

    private static int blockToSectionCoord(int block) {
        return block >> 4;
    }

    public static Collection<BukkitWorldAccessor> getWorlds() {
        return ACCESSOR_LOOKUP.values();
    }

    public static void registerListener(Plugin plugin) {
        for (World world : Bukkit.getWorlds()) {
            ACCESSOR_LOOKUP.put(world, new BukkitWorldAccessor(world));
        }
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onWorldUnload(WorldLoadEvent event) {
                World world = event.getWorld();
                ACCESSOR_LOOKUP.put(world, new BukkitWorldAccessor(world));
            }

            @EventHandler
            public void onWorldUnload(WorldUnloadEvent event) {
                ACCESSOR_LOOKUP.remove(event.getWorld());
            }
        }, plugin);
    }

    private BukkitWorldAccessor(World world) {
        this.world = Objects.requireNonNull(world);
        if (HAS_DYNAMIC_HEIGHT) {
            this.maxHeight = (Integer)WORLD_GET_MAX_HEIGHT.invoke((Object)world, new Object[0]);
            this.minHeight = (Integer)WORLD_GET_MIN_HEIGHT.invoke((Object)world, new Object[0]);
        } else {
            this.maxHeight = 256;
            this.minHeight = 0;
        }
    }

    @Override
    public String getName() {
        return this.world.getName();
    }

    @Override
    public int getHeight() {
        return this.maxHeight - this.minHeight;
    }

    @Override
    public int getMinBuildHeight() {
        return this.minHeight;
    }

    @Override
    public int getMaxBuildHeight() {
        return this.maxHeight;
    }

    @Override
    public int getSectionCount() {
        return this.getMaxSection() - this.getMinSection();
    }

    @Override
    public int getMinSection() {
        return BukkitWorldAccessor.blockToSectionCoord(this.getMinBuildHeight());
    }

    @Override
    public int getMaxSection() {
        return BukkitWorldAccessor.blockToSectionCoord(this.getMaxBuildHeight() - 1) + 1;
    }

    @Override
    public int getSectionIndex(int y) {
        return BukkitWorldAccessor.blockToSectionCoord(y) - this.getMinSection();
    }

    public int hashCode() {
        return this.world.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BukkitWorldAccessor)) return false;
        BukkitWorldAccessor other = (BukkitWorldAccessor)obj;
        if (!this.world.equals((Object)other.world)) return false;
        return true;
    }

    public String toString() {
        return String.format("[%s, minY=%s, maxY=%s]", this.world.getName(), this.minHeight, this.maxHeight);
    }
}

