/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator.iterop;

import dev.imprex.orebfuscator.logging.LogLevel;
import dev.imprex.orebfuscator.logging.LoggerAccessor;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.imprex.shaded.org.jetbrains.annotations.NotNull;
import net.imprex.shaded.org.jetbrains.annotations.Nullable;

public class BukkitLoggerAccessor
implements LoggerAccessor {
    private final Logger logger;

    public BukkitLoggerAccessor(@NotNull Logger logger) {
        this.logger = Objects.requireNonNull(logger, "Plugin logger can't be null");
    }

    @Override
    public void log(@NotNull LogLevel level, @NotNull String message, @Nullable Throwable throwable) {
        Level mappedLevel;
        switch (level) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case DEBUG: 
            case INFO: {
                Level level2 = Level.INFO;
                break;
            }
            case WARN: {
                Level level2 = Level.WARNING;
                break;
            }
            case ERROR: {
                Level level2 = mappedLevel = Level.SEVERE;
            }
        }
        if (level == LogLevel.DEBUG) {
            message = "[Debug] " + (String)message;
        }
        this.logger.log(mappedLevel, (String)message, throwable);
    }
}

