/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator.iterop;

import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import dev.imprex.orebfuscator.interop.ChunkPacketAccessor;
import dev.imprex.orebfuscator.interop.WorldAccessor;
import dev.imprex.orebfuscator.util.BlockPos;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.imprex.orebfuscator.iterop.BukkitWorldAccessor;
import net.imprex.orebfuscator.util.MinecraftVersion;
import net.imprex.orebfuscator.util.WrappedClientboundLevelChunkPacketData;

public class BukkitChunkPacketAccessor
implements ChunkPacketAccessor {
    private static final boolean HAS_CLIENTBOUND_LEVEL_CHUNK_PACKET_DATA = MinecraftVersion.isAtOrAbove("1.18");
    private static final boolean HAS_HEIGHT_BITMASK = MinecraftVersion.isBelow("1.18");
    private static final boolean HAS_VARINT_BITMASK = MinecraftVersion.isBelow("1.17");
    public final BukkitWorldAccessor worldAccessor;
    private final int chunkX;
    private final int chunkZ;
    private final BitSet sectionMask;
    private final byte[] data;
    private final PacketContainer packet;
    private final WrappedClientboundLevelChunkPacketData packetData;

    public BukkitChunkPacketAccessor(PacketContainer packet, BukkitWorldAccessor worldAccessor) {
        this.packet = packet;
        this.worldAccessor = worldAccessor;
        StructureModifier packetInteger = packet.getIntegers();
        this.chunkX = (Integer)packetInteger.read(0);
        this.chunkZ = (Integer)packetInteger.read(1);
        if (HAS_CLIENTBOUND_LEVEL_CHUNK_PACKET_DATA) {
            this.packetData = new WrappedClientboundLevelChunkPacketData(packet);
            this.data = this.packetData.getBuffer();
        } else {
            this.packetData = null;
            this.data = (byte[])packet.getByteArrays().read(0);
        }
        if (HAS_HEIGHT_BITMASK) {
            this.sectionMask = HAS_VARINT_BITMASK ? BukkitChunkPacketAccessor.convertIntToBitSet((Integer)packetInteger.read(2)) : (BitSet)packet.getSpecificModifier(BitSet.class).read(0);
        } else {
            this.sectionMask = new BitSet();
            this.sectionMask.set(0, worldAccessor.getSectionCount());
        }
    }

    @Override
    public WorldAccessor world() {
        return this.worldAccessor;
    }

    @Override
    public int chunkX() {
        return this.chunkX;
    }

    @Override
    public int chunkZ() {
        return this.chunkZ;
    }

    @Override
    public boolean isSectionPresent(int index) {
        return this.sectionMask.get(index);
    }

    @Override
    public byte[] data() {
        return this.data;
    }

    @Override
    public void setData(byte[] data) {
        if (this.packetData != null) {
            this.packetData.setBuffer(data);
        } else {
            this.packet.getByteArrays().write(0, (Object)data);
        }
    }

    @Override
    public void filterBlockEntities(Predicate<BlockPos> predicate) {
        if (this.packetData != null) {
            this.packetData.removeBlockEntityIf(relativePostion -> predicate.test(relativePostion.add(this.chunkX << 4, 0, this.chunkZ << 4)));
        } else {
            this.removeTileEntitiesFromPacket(this.packet, predicate);
        }
    }

    private void removeTileEntitiesFromPacket(PacketContainer packet, Predicate<BlockPos> predicate) {
        StructureModifier packetNbtList = packet.getListNbtModifier();
        List tileEntities = (List)packetNbtList.read(0);
        this.removeTileEntities(tileEntities, predicate);
        packetNbtList.write(0, (Object)tileEntities);
    }

    private void removeTileEntities(List<NbtBase<?>> tileEntities, Predicate<BlockPos> predicate) {
        Iterator<NbtBase<?>> iterator = tileEntities.iterator();
        while (iterator.hasNext()) {
            int z;
            int y;
            NbtCompound tileEntity = (NbtCompound)iterator.next();
            int x = tileEntity.getInteger("x");
            BlockPos position = new BlockPos(x, y = tileEntity.getInteger("y"), z = tileEntity.getInteger("z"));
            if (!predicate.test(position)) continue;
            iterator.remove();
        }
    }

    public boolean isEmpty() {
        return this.sectionMask.isEmpty();
    }

    private static BitSet convertIntToBitSet(int value) {
        BitSet bitSet = new BitSet();
        int index = 0;
        while (value != 0) {
            if ((value & 1) == 1) {
                bitSet.set(index);
            }
            value >>>= 1;
            ++index;
        }
        return bitSet;
    }
}

