/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator;

import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;

public class OrebfuscatorStatistics {
    private final AtomicLong cacheHitCountMemory = new AtomicLong(0L);
    private final AtomicLong cacheHitCountDisk = new AtomicLong(0L);
    private final AtomicLong cacheMissCount = new AtomicLong(0L);
    private final AtomicLong cacheEstimatedSize = new AtomicLong(0L);
    private LongSupplier memoryCacheSize = () -> 0L;
    private LongSupplier diskCacheQueueLength = () -> 0L;
    private LongSupplier obfuscationQueueLength = () -> 0L;
    private LongSupplier obfuscationWaitTime = () -> 0L;
    private LongSupplier obfuscationProcessTime = () -> 0L;
    private LongSupplier proximityWaitTime = () -> 0L;
    private LongSupplier proximityProcessTime = () -> 0L;
    private LongSupplier originalChunkSize = () -> 0L;
    private LongSupplier obfuscatedChunkSize = () -> 0L;

    private static String formatPrecent(double percent) {
        return String.format("%.2f%%", percent * 100.0);
    }

    private static String formatNanos(long time) {
        if (time > 1000000L) {
            return String.format("%.1fms", (double)time / 1000000.0);
        }
        if (time > 1000L) {
            return String.format("%.1f\u00b5s", (double)time / 1000.0);
        }
        return String.format("%dns", time);
    }

    private static String formatBytes(long bytes) {
        if (bytes > 0x40000000L) {
            return String.format("%.1f GiB", (double)bytes / 1.073741824E9);
        }
        if (bytes > 0x100000L) {
            return String.format("%.1f MiB", (double)bytes / 1048576.0);
        }
        if (bytes > 1024L) {
            return String.format("%.1f KiB", (double)bytes / 1024.0);
        }
        return String.format("%d B", bytes);
    }

    public void onCacheHitMemory() {
        this.cacheHitCountMemory.incrementAndGet();
    }

    public void onCacheHitDisk() {
        this.cacheHitCountDisk.incrementAndGet();
    }

    public void onCacheMiss() {
        this.cacheMissCount.incrementAndGet();
    }

    public void onCacheSizeChange(int delta) {
        this.cacheEstimatedSize.addAndGet(delta);
    }

    public void setMemoryCacheSizeSupplier(LongSupplier supplier) {
        this.memoryCacheSize = Objects.requireNonNull(supplier);
    }

    public void setDiskCacheQueueLengthSupplier(LongSupplier supplier) {
        this.diskCacheQueueLength = Objects.requireNonNull(supplier);
    }

    public void setObfuscationQueueLengthSupplier(LongSupplier supplier) {
        this.obfuscationQueueLength = Objects.requireNonNull(supplier);
    }

    public void setObfuscationWaitTime(LongSupplier supplier) {
        this.obfuscationWaitTime = Objects.requireNonNull(supplier);
    }

    public void setObfuscationProcessTime(LongSupplier supplier) {
        this.obfuscationProcessTime = Objects.requireNonNull(supplier);
    }

    public void setProximityWaitTime(LongSupplier supplier) {
        this.proximityWaitTime = Objects.requireNonNull(supplier);
    }

    public void setProximityProcessTime(LongSupplier supplier) {
        this.proximityProcessTime = Objects.requireNonNull(supplier);
    }

    public void setOriginalChunkSize(LongSupplier supplier) {
        this.originalChunkSize = Objects.requireNonNull(supplier);
    }

    public void setObfuscatedChunkSize(LongSupplier supplier) {
        this.obfuscatedChunkSize = Objects.requireNonNull(supplier);
    }

    public String toString() {
        long cacheHitCountMemory = this.cacheHitCountMemory.get();
        long cacheHitCountDisk = this.cacheHitCountDisk.get();
        long cacheMissCount = this.cacheMissCount.get();
        long cacheEstimatedSize = this.cacheEstimatedSize.get();
        long memoryCacheSize = this.memoryCacheSize.getAsLong();
        long diskCacheQueueLength = this.diskCacheQueueLength.getAsLong();
        long obfuscationQueueLength = this.obfuscationQueueLength.getAsLong();
        double totalCacheRequest = cacheHitCountMemory + cacheHitCountDisk + cacheMissCount;
        double memoryCacheHitRate = 0.0;
        double diskCacheHitRate = 0.0;
        if (totalCacheRequest > 0.0) {
            memoryCacheHitRate = (double)cacheHitCountMemory / totalCacheRequest;
            diskCacheHitRate = (double)cacheHitCountDisk / totalCacheRequest;
        }
        long memoryCacheBytesPerEntry = 0L;
        if (memoryCacheSize > 0L) {
            memoryCacheBytesPerEntry = cacheEstimatedSize / memoryCacheSize;
        }
        StringBuilder builder = new StringBuilder("Here are some useful statistics:\n");
        builder.append(" - memoryCacheHitRate: ").append(OrebfuscatorStatistics.formatPrecent(memoryCacheHitRate)).append('\n');
        builder.append(" - diskCacheHitRate: ").append(OrebfuscatorStatistics.formatPrecent(diskCacheHitRate)).append('\n');
        builder.append(" - memoryCacheEstimatedSize: ").append(OrebfuscatorStatistics.formatBytes(cacheEstimatedSize)).append('\n');
        builder.append(" - memoryCacheBytesPerEntry: ").append(OrebfuscatorStatistics.formatBytes(memoryCacheBytesPerEntry)).append('\n');
        builder.append(" - memoryCacheEntries: ").append(memoryCacheSize).append('\n');
        builder.append(" - diskCacheQueueLength: ").append(diskCacheQueueLength).append('\n');
        builder.append(" - obfuscationQueueLength: ").append(obfuscationQueueLength).append('\n');
        long obfuscationWaitTime = this.obfuscationWaitTime.getAsLong();
        long obfuscationProcessTime = this.obfuscationProcessTime.getAsLong();
        long obfuscationTotalTime = obfuscationWaitTime + obfuscationProcessTime;
        double obfuscationUtilization = 0.0;
        if (obfuscationTotalTime > 0L) {
            obfuscationUtilization = (double)obfuscationProcessTime / (double)obfuscationTotalTime;
        }
        builder.append(" - obfuscation (wait/process/utilization): ").append(OrebfuscatorStatistics.formatNanos(obfuscationWaitTime)).append(" | ").append(OrebfuscatorStatistics.formatNanos(obfuscationProcessTime)).append(" | ").append(OrebfuscatorStatistics.formatPrecent(obfuscationUtilization)).append('\n');
        long proximityWaitTime = this.proximityWaitTime.getAsLong();
        long proximityProcessTime = this.proximityProcessTime.getAsLong();
        long proximityTotalTime = proximityWaitTime + proximityProcessTime;
        double proximityUtilization = 0.0;
        if (proximityTotalTime > 0L) {
            proximityUtilization = (double)proximityProcessTime / (double)proximityTotalTime;
        }
        builder.append(" - proximity (wait/process/utilization): ").append(OrebfuscatorStatistics.formatNanos(proximityWaitTime)).append(" | ").append(OrebfuscatorStatistics.formatNanos(proximityProcessTime)).append(" | ").append(OrebfuscatorStatistics.formatPrecent(proximityUtilization)).append('\n');
        long originalChunkSize = this.originalChunkSize.getAsLong();
        long obfuscatedChunkSize = this.obfuscatedChunkSize.getAsLong();
        double ratio = 1.0;
        if (originalChunkSize > 0L) {
            ratio = (double)obfuscatedChunkSize / (double)originalChunkSize;
        }
        builder.append(" - chunk size (original/obfuscated/ratio): ").append(OrebfuscatorStatistics.formatBytes(originalChunkSize)).append(" | ").append(OrebfuscatorStatistics.formatBytes(obfuscatedChunkSize)).append(" | ").append(OrebfuscatorStatistics.formatPrecent(ratio)).append('\n');
        return builder.toString();
    }

    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("cacheHitCountMemory", (Number)this.cacheHitCountMemory.get());
        object.addProperty("cacheHitCountDisk", (Number)this.cacheHitCountDisk.get());
        object.addProperty("cacheMissCount", (Number)this.cacheMissCount.get());
        object.addProperty("cacheEstimatedSize", (Number)this.cacheEstimatedSize.get());
        object.addProperty("memoryCacheSize", (Number)this.memoryCacheSize.getAsLong());
        object.addProperty("diskCacheQueueLength", (Number)this.diskCacheQueueLength.getAsLong());
        object.addProperty("obfuscationQueueLength", (Number)this.obfuscationQueueLength.getAsLong());
        object.addProperty("obfuscationWaitTime", (Number)this.obfuscationWaitTime.getAsLong());
        object.addProperty("obfuscationProcessTime", (Number)this.obfuscationProcessTime.getAsLong());
        object.addProperty("proximityWaitTime", (Number)this.proximityWaitTime.getAsLong());
        object.addProperty("proximityProcessTime", (Number)this.proximityProcessTime.getAsLong());
        object.addProperty("originalChunkSize", (Number)this.originalChunkSize.getAsLong());
        object.addProperty("obfuscatedChunkSize", (Number)this.obfuscatedChunkSize.getAsLong());
        return object;
    }
}

