/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator;

import dev.imprex.orebfuscator.cache.AbstractRegionFileCache;
import dev.imprex.orebfuscator.config.api.Config;
import dev.imprex.orebfuscator.interop.RegistryAccessor;
import dev.imprex.orebfuscator.logging.OfcLogger;
import dev.imprex.orebfuscator.util.BlockPos;
import java.lang.reflect.Constructor;
import net.imprex.orebfuscator.nms.NmsManager;
import net.imprex.orebfuscator.nms.ReadOnlyChunk;
import net.imprex.orebfuscator.util.MinecraftVersion;
import net.imprex.orebfuscator.util.ServerVersion;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class OrebfuscatorNms {
    private static NmsManager instance;

    public static void initialize() {
        if (instance != null) {
            throw new IllegalStateException("NMS adapter is already initialized!");
        }
        Object nmsVersion = MinecraftVersion.nmsVersion();
        if (ServerVersion.isMojangMapped()) {
            nmsVersion = (String)nmsVersion + "_mojang";
        }
        OfcLogger.info("Searching NMS adapter for server version \"" + (String)nmsVersion + "\"!");
        try {
            String className = "net.imprex.orebfuscator.nms." + (String)nmsVersion + ".NmsManager";
            Class<NmsManager> nmsManager = Class.forName(className).asSubclass(NmsManager.class);
            Constructor<NmsManager> constructor = nmsManager.getConstructor(new Class[0]);
            instance = constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Server version \"" + (String)nmsVersion + "\" is currently not supported!", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't initialize NMS adapter", e);
        }
        OfcLogger.info("NMS adapter for server version \"" + (String)nmsVersion + "\" found!");
    }

    public static RegistryAccessor registry() {
        return instance;
    }

    public static AbstractRegionFileCache<?> createRegionFileCache(Config config) {
        return instance.createRegionFileCache(config);
    }

    public static int getUniqueBlockStateCount() {
        return instance.getUniqueBlockStateCount();
    }

    public static int getMaxBitsPerBlockState() {
        return instance.getMaxBitsPerBlockState();
    }

    public static boolean isAir(int blockId) {
        return instance.isAir(blockId);
    }

    public static boolean isOccluding(int blockId) {
        return instance.isOccluding(blockId);
    }

    public static boolean isBlockEntity(int blockId) {
        return instance.isBlockEntity(blockId);
    }

    public static ReadOnlyChunk getReadOnlyChunk(World world, int chunkX, int chunkZ) {
        return instance.getReadOnlyChunk(world, chunkX, chunkZ);
    }

    public static int getBlockState(World world, BlockPos position) {
        return OrebfuscatorNms.getBlockState(world, position.x(), position.y(), position.z());
    }

    public static int getBlockState(World world, int x, int y, int z) {
        return instance.getBlockState(world, x, y, z);
    }

    public static void sendBlockUpdates(World world, Iterable<BlockPos> iterable) {
        instance.sendBlockUpdates(world, iterable);
    }

    public static void sendBlockUpdates(Player player, Iterable<BlockPos> iterable) {
        instance.sendBlockUpdates(player, iterable);
    }
}

