/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator;

import dev.imprex.orebfuscator.chunk.ChunkFactory;
import dev.imprex.orebfuscator.config.OrebfuscatorConfig;
import dev.imprex.orebfuscator.interop.RegistryAccessor;
import dev.imprex.orebfuscator.interop.ServerAccessor;
import dev.imprex.orebfuscator.interop.WorldAccessor;
import dev.imprex.orebfuscator.logging.OfcLogger;
import dev.imprex.orebfuscator.util.Version;
import java.nio.file.Path;
import java.util.List;
import net.imprex.orebfuscator.DefaultOrebfuscatorService;
import net.imprex.orebfuscator.MetricsSystem;
import net.imprex.orebfuscator.OrebfuscatorCommand;
import net.imprex.orebfuscator.OrebfuscatorCompatibility;
import net.imprex.orebfuscator.OrebfuscatorNms;
import net.imprex.orebfuscator.OrebfuscatorStatistics;
import net.imprex.orebfuscator.UpdateSystem;
import net.imprex.orebfuscator.api.OrebfuscatorService;
import net.imprex.orebfuscator.cache.ObfuscationCache;
import net.imprex.orebfuscator.iterop.BukkitLoggerAccessor;
import net.imprex.orebfuscator.iterop.BukkitWorldAccessor;
import net.imprex.orebfuscator.obfuscation.ObfuscationSystem;
import net.imprex.orebfuscator.player.OrebfuscatorPlayerMap;
import net.imprex.orebfuscator.proximity.ProximityDirectorThread;
import net.imprex.orebfuscator.proximity.ProximityPacketListener;
import net.imprex.orebfuscator.util.MinecraftVersion;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public class Orebfuscator
extends JavaPlugin
implements Listener,
ServerAccessor {
    public static final ThreadGroup THREAD_GROUP = new ThreadGroup("orebfuscator");
    private OrebfuscatorStatistics statistics;
    private OrebfuscatorConfig config;
    private OrebfuscatorPlayerMap playerMap;
    private UpdateSystem updateSystem;
    private ObfuscationCache obfuscationCache;
    private ObfuscationSystem obfuscationSystem;
    private ProximityDirectorThread proximityThread;
    private ProximityPacketListener proximityPacketListener;
    private ChunkFactory chunkFactory;

    public void onLoad() {
        OfcLogger.setLogger(new BukkitLoggerAccessor(this.getLogger()));
    }

    public void onEnable() {
        try {
            if (MinecraftVersion.isBelow("1.16")) {
                throw new RuntimeException("Orebfuscator only supports minecraft 1.16 and above");
            }
            Plugin protocolLib = this.getServer().getPluginManager().getPlugin("ProtocolLib");
            if (protocolLib == null || !protocolLib.isEnabled()) {
                throw new RuntimeException("ProtocolLib can't be found or is disabled! Orebfuscator can't be enabled.");
            }
            BukkitWorldAccessor.registerListener((Plugin)this);
            this.statistics = new OrebfuscatorStatistics();
            OrebfuscatorNms.initialize();
            this.config = new OrebfuscatorConfig(this);
            OrebfuscatorCompatibility.initialize((Plugin)this, this.config);
            this.playerMap = new OrebfuscatorPlayerMap(this);
            new MetricsSystem(this);
            this.updateSystem = new UpdateSystem(this);
            this.obfuscationCache = new ObfuscationCache(this);
            this.chunkFactory = new ChunkFactory(this);
            this.obfuscationSystem = new ObfuscationSystem(this);
            this.proximityThread = new ProximityDirectorThread(this);
            if (this.config.proximityEnabled()) {
                this.proximityThread.start();
                this.proximityPacketListener = new ProximityPacketListener(this);
            }
            this.obfuscationSystem.registerChunkListener();
            this.config.store();
            Bukkit.getServicesManager().register(OrebfuscatorService.class, (Object)new DefaultOrebfuscatorService(this), (Plugin)this, ServicePriority.Normal);
            this.getCommand("orebfuscator").setExecutor((CommandExecutor)new OrebfuscatorCommand(this));
        }
        catch (Exception e) {
            OfcLogger.error("An error occurred while enabling plugin", e);
            this.getServer().getPluginManager().registerEvent(PluginEnableEvent.class, (Listener)this, EventPriority.NORMAL, this::onEnableFailed, (Plugin)this);
        }
    }

    public void onDisable() {
        if (this.obfuscationCache != null) {
            this.obfuscationCache.close();
        }
        if (this.obfuscationSystem != null) {
            this.obfuscationSystem.shutdown();
        }
        if (this.config != null && this.config.proximityEnabled() && this.proximityPacketListener != null && this.proximityThread != null) {
            this.proximityPacketListener.unregister();
            this.proximityThread.close();
        }
        OrebfuscatorCompatibility.close();
        this.config = null;
    }

    public void onEnableFailed(Listener listener, Event event) {
        PluginEnableEvent enableEvent = (PluginEnableEvent)event;
        if (enableEvent.getPlugin() == this) {
            HandlerList.unregisterAll((Listener)listener);
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public OrebfuscatorStatistics getStatistics() {
        return this.statistics;
    }

    public OrebfuscatorConfig getOrebfuscatorConfig() {
        return this.config;
    }

    public OrebfuscatorPlayerMap getPlayerMap() {
        return this.playerMap;
    }

    public UpdateSystem getUpdateSystem() {
        return this.updateSystem;
    }

    public ObfuscationCache getObfuscationCache() {
        return this.obfuscationCache;
    }

    public ObfuscationSystem getObfuscationSystem() {
        return this.obfuscationSystem;
    }

    public ProximityPacketListener getProximityPacketListener() {
        return this.proximityPacketListener;
    }

    public ChunkFactory getChunkFactory() {
        return this.chunkFactory;
    }

    @Override
    public Path getConfigDirectory() {
        return this.getDataFolder().toPath();
    }

    @Override
    public Path getWorldDirectory() {
        return Bukkit.getWorldContainer().toPath();
    }

    @Override
    public String getOrebfuscatorVersion() {
        return this.getDescription().getVersion();
    }

    @Override
    public Version getMinecraftVersion() {
        return MinecraftVersion.current();
    }

    @Override
    public RegistryAccessor getRegistry() {
        return OrebfuscatorNms.registry();
    }

    @Override
    public List<WorldAccessor> getWorlds() {
        return BukkitWorldAccessor.getWorlds().stream().map(WorldAccessor.class::cast).toList();
    }
}

