/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator;

import dev.imprex.orebfuscator.config.OrebfuscatorConfig;
import dev.imprex.orebfuscator.util.MathUtil;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.imprex.orebfuscator.Orebfuscator;
import net.imprex.shaded.org.bstats.bukkit.Metrics;
import net.imprex.shaded.org.bstats.charts.DrilldownPie;
import net.imprex.shaded.org.bstats.charts.SimplePie;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class MetricsSystem {
    private static final NavigableMap<Integer, String> PLAYER_COUNT_GROUPS = new TreeMap<Integer, String>();
    private final Metrics metrics;

    public MetricsSystem(Orebfuscator orebfuscator) {
        this.metrics = new Metrics((Plugin)orebfuscator, 8942);
        this.addMemoryChart();
        this.addPlayerCountChart();
        this.addConfigCharts(orebfuscator.getOrebfuscatorConfig());
        this.addUsageCharts(orebfuscator.getOrebfuscatorConfig());
    }

    public void addMemoryChart() {
        this.metrics.addCustomChart(new DrilldownPie("systemMemory", () -> {
            HashMap result = new HashMap();
            HashMap<CallSite, Integer> exact = new HashMap<CallSite, Integer>();
            long memory = Runtime.getRuntime().maxMemory();
            if (memory == Long.MAX_VALUE) {
                result.put("unlimited", exact);
            } else {
                float gibiByte = (float)Math.round((float)memory / 1.0737418E9f * 100.0f) / 100.0f;
                exact.put((CallSite)((Object)(gibiByte + "GiB")), 1);
                result.put(MathUtil.ceilToPowerOfTwo((int)gibiByte) + "GiB", exact);
            }
            return result;
        }));
    }

    public void addPlayerCountChart() {
        this.metrics.addCustomChart(new SimplePie("player_count", () -> {
            int playerCount = Bukkit.getOnlinePlayers().size();
            return PLAYER_COUNT_GROUPS.ceilingEntry(playerCount).getValue();
        }));
    }

    public void addConfigCharts(OrebfuscatorConfig config) {
        this.metrics.addCustomChart(new SimplePie("max_mspt", () -> Integer.toString(config.advanced().maxMillisecondsPerTick())));
        this.metrics.addCustomChart(new SimplePie("update_radius", () -> Integer.toString(config.general().updateRadius())));
    }

    public void addUsageCharts(OrebfuscatorConfig config) {
        this.metrics.addCustomChart(new SimplePie("check_for_updates", () -> Boolean.toString(config.general().checkForUpdates())));
        this.metrics.addCustomChart(new SimplePie("ignore_spectator", () -> Boolean.toString(config.general().ignoreSpectator())));
        this.metrics.addCustomChart(new SimplePie("cache", () -> Boolean.toString(config.cache().enabled())));
        this.metrics.addCustomChart(new SimplePie("proximity", () -> Boolean.toString(config.proximityEnabled())));
        this.metrics.addCustomChart(new SimplePie("block_specific_config", () -> Boolean.toString(config.usesBlockSpecificConfigs())));
        this.metrics.addCustomChart(new SimplePie("frustum_culling", () -> Boolean.toString(config.usesFrustumCulling())));
        this.metrics.addCustomChart(new SimplePie("ray_cast", () -> config.usesRayCastCheck()));
    }

    static {
        PLAYER_COUNT_GROUPS.put(8, "0-8");
        PLAYER_COUNT_GROUPS.put(16, "9-16");
        PLAYER_COUNT_GROUPS.put(32, "17-32");
        PLAYER_COUNT_GROUPS.put(64, "33-64");
        PLAYER_COUNT_GROUPS.put(128, "65-128");
        PLAYER_COUNT_GROUPS.put(Integer.MAX_VALUE, ">129");
    }
}

