/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.util;

public class BlockStateProperties {
    private final int id;
    private final boolean isAir;
    private final boolean isOccluding;
    private final boolean isBlockEntity;
    private final boolean isDefaultState;

    public static Builder builder(int id) {
        return new Builder(id);
    }

    private BlockStateProperties(Builder builder) {
        this.id = builder.id;
        this.isAir = builder.isAir;
        this.isOccluding = builder.isOccluding;
        this.isBlockEntity = builder.isBlockEntity;
        this.isDefaultState = builder.isDefaultState;
    }

    public int getId() {
        return this.id;
    }

    public boolean isAir() {
        return this.isAir;
    }

    public boolean isOccluding() {
        return this.isOccluding;
    }

    public boolean isBlockEntity() {
        return this.isBlockEntity;
    }

    public boolean isDefaultState() {
        return this.isDefaultState;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BlockStateProperties)) {
            return false;
        }
        BlockStateProperties other = (BlockStateProperties)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "BlockStateProperties [id=" + this.id + ", isDefaultState=" + this.isDefaultState + ", isAir=" + this.isAir + ", isOccluding=" + this.isOccluding + ", isBlockEntity=" + this.isBlockEntity + "]";
    }

    public static class Builder {
        private final int id;
        private boolean isAir;
        private boolean isOccluding;
        private boolean isBlockEntity;
        private boolean isDefaultState;

        private Builder(int id) {
            this.id = id;
        }

        public Builder withIsAir(boolean isAir) {
            this.isAir = isAir;
            return this;
        }

        public Builder withIsOccluding(boolean isOccluding) {
            this.isOccluding = isOccluding;
            return this;
        }

        public Builder withIsBlockEntity(boolean isBlockEntity) {
            this.isBlockEntity = isBlockEntity;
            return this;
        }

        public Builder withIsDefaultState(boolean isDefaultState) {
            this.isDefaultState = isDefaultState;
            return this;
        }

        public BlockStateProperties build() {
            return new BlockStateProperties(this);
        }
    }
}

