/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.util;

import dev.imprex.orebfuscator.util.BlockStateProperties;
import dev.imprex.orebfuscator.util.NamespacedKey;
import dev.imprex.shaded.com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class BlockProperties {
    private final NamespacedKey key;
    private final BlockStateProperties defaultBlockState;
    private final ImmutableList<BlockStateProperties> blockStates;

    public static Builder builder(NamespacedKey key) {
        return new Builder(key);
    }

    private BlockProperties(Builder builder) {
        this.key = builder.key;
        this.defaultBlockState = builder.defaultBlockState;
        this.blockStates = ImmutableList.copyOf(builder.blockStates);
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public BlockStateProperties getDefaultBlockState() {
        return this.defaultBlockState;
    }

    public ImmutableList<BlockStateProperties> getBlockStates() {
        return this.blockStates;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BlockProperties)) {
            return false;
        }
        BlockProperties other = (BlockProperties)obj;
        return Objects.equals(this.key, other.key);
    }

    public String toString() {
        return "BlockProperties [key=" + String.valueOf(this.key) + ", defaultBlockState=" + String.valueOf(this.defaultBlockState) + ", blockStates=" + String.valueOf(this.blockStates) + "]";
    }

    public static class Builder {
        private final NamespacedKey key;
        private BlockStateProperties defaultBlockState;
        private final Set<BlockStateProperties> blockStates = new HashSet<BlockStateProperties>();

        private Builder(NamespacedKey key) {
            this.key = key;
        }

        public Builder withBlockState(BlockStateProperties blockState) {
            if (!this.blockStates.add(blockState)) {
                throw new IllegalStateException(String.format("duplicate block state id (%s) for block: %s", blockState.getId(), this.key));
            }
            if (blockState.isDefaultState()) {
                if (this.defaultBlockState != null) {
                    throw new IllegalStateException(String.format("multiple default block states for block: %s", blockState.getId(), this.key));
                }
                this.defaultBlockState = blockState;
            }
            return this;
        }

        public BlockProperties build() {
            Objects.requireNonNull(this.defaultBlockState, "missing default block state for block: " + String.valueOf(this.key));
            if (this.blockStates.size() == 0) {
                throw new IllegalStateException("missing block states for block: " + String.valueOf(this.key));
            }
            return new BlockProperties(this);
        }
    }
}

