/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.reflect.predicate;

import dev.imprex.orebfuscator.reflect.accessor.MethodAccessor;
import dev.imprex.orebfuscator.reflect.predicate.AbstractExecutablePredicate;
import dev.imprex.orebfuscator.reflect.predicate.ClassPredicate;
import dev.imprex.orebfuscator.reflect.predicate.RequirementCollector;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.imprex.shaded.org.jetbrains.annotations.NotNull;
import net.imprex.shaded.org.jetbrains.annotations.Nullable;

public final class MethodPredicate
extends AbstractExecutablePredicate<MethodPredicate, MethodAccessor, Method> {
    @Nullable
    private ClassPredicate returnType;

    public MethodPredicate(@NotNull Function<MethodPredicate, Stream<MethodAccessor>> producer, @NotNull Supplier<String> className) {
        super(producer, () -> String.format("Can't find constructor in class %s matching: ", className.get()));
    }

    @Override
    public boolean test(@NotNull Method method) {
        return super.test(method) && (this.returnType == null || this.returnType.test(method.getReturnType()));
    }

    @Override
    void requirements(@NotNull RequirementCollector collector) {
        super.requirements(collector);
        if (this.returnType != null) {
            collector.collect("returnType", this.returnType.requirement());
        }
    }

    @NotNull
    public MethodPredicate returnType(@NotNull ClassPredicate matcher) {
        this.returnType = Objects.requireNonNull(matcher);
        return this;
    }

    @NotNull
    public ClassPredicate.Builder<MethodPredicate> returnType() {
        return new ClassPredicate.Builder<MethodPredicate>(this::returnType);
    }

    @Override
    @NotNull
    protected MethodPredicate instance() {
        return this;
    }
}

