/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.reflect.predicate;

import dev.imprex.orebfuscator.reflect.accessor.MemberAccessor;
import dev.imprex.orebfuscator.reflect.predicate.AbstractMemberPredicate;
import dev.imprex.orebfuscator.reflect.predicate.ClassPredicate;
import dev.imprex.orebfuscator.reflect.predicate.RequirementCollector;
import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.imprex.shaded.org.jetbrains.annotations.NotNull;
import net.imprex.shaded.org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class AbstractExecutablePredicate<TThis extends AbstractExecutablePredicate<TThis, TAccessor, TExecutable>, TAccessor extends MemberAccessor<TExecutable>, TExecutable extends Executable>
extends AbstractMemberPredicate<TThis, TAccessor, TExecutable> {
    @NotNull
    private final List<IndexedClassMatcher> exceptionClass = new ArrayList<IndexedClassMatcher>();
    @NotNull
    private final List<IndexedClassMatcher> parameterClass = new ArrayList<IndexedClassMatcher>();
    private int parameterCount = -1;

    public AbstractExecutablePredicate(@NotNull Function<TThis, Stream<TAccessor>> producer, @NotNull Supplier<String> error) {
        super(producer, error);
    }

    @Override
    public boolean test(@NotNull TExecutable executable) {
        return super.test(executable) && IndexedClassMatcher.all(((Executable)executable).getExceptionTypes(), this.exceptionClass) && IndexedClassMatcher.all(((Executable)executable).getParameterTypes(), this.parameterClass) && (this.parameterCount < 0 || this.parameterCount == ((Executable)executable).getParameterCount());
    }

    @Override
    void requirements(@NotNull RequirementCollector collector) {
        super.requirements(collector);
        if (!this.exceptionClass.isEmpty()) {
            collector.collect("exceptionClass", IndexedClassMatcher.toString(this.exceptionClass));
        }
        if (!this.parameterClass.isEmpty()) {
            collector.collect("parameterClass", IndexedClassMatcher.toString(this.parameterClass));
        }
        if (this.parameterCount >= 0) {
            collector.collect("parameterCount", this.parameterCount);
        }
    }

    @NotNull
    public TThis exception(@NotNull ClassPredicate matcher) {
        this.exceptionClass.add(new IndexedClassMatcher(Objects.requireNonNull(matcher)));
        return (TThis)((AbstractExecutablePredicate)this.instance());
    }

    @NotNull
    public TThis exception(@NotNull ClassPredicate matcher, int index) {
        this.exceptionClass.add(new IndexedClassMatcher(Objects.requireNonNull(matcher), index));
        return (TThis)((AbstractExecutablePredicate)this.instance());
    }

    @NotNull
    public ClassPredicate.Builder<TThis> exception() {
        return new ClassPredicate.Builder<AbstractExecutablePredicate>(this::exception);
    }

    @NotNull
    public ClassPredicate.Builder<TThis> exception(int index) {
        return new ClassPredicate.Builder<AbstractExecutablePredicate>(m -> this.exception((ClassPredicate)m, index));
    }

    @NotNull
    public TThis parameter(@NotNull ClassPredicate matcher) {
        this.parameterClass.add(new IndexedClassMatcher(Objects.requireNonNull(matcher)));
        return (TThis)((AbstractExecutablePredicate)this.instance());
    }

    @NotNull
    public TThis parameter(@NotNull ClassPredicate matcher, int index) {
        this.parameterClass.add(new IndexedClassMatcher(Objects.requireNonNull(matcher), index));
        return (TThis)((AbstractExecutablePredicate)this.instance());
    }

    @NotNull
    public ClassPredicate.Builder<TThis> parameter() {
        return new ClassPredicate.Builder<AbstractExecutablePredicate>(this::parameter);
    }

    @NotNull
    public ClassPredicate.Builder<TThis> parameter(int index) {
        return new ClassPredicate.Builder<AbstractExecutablePredicate>(m -> this.parameter((ClassPredicate)m, index));
    }

    @NotNull
    public TThis parameterCount(int parameterCount) {
        this.parameterCount = parameterCount;
        return (TThis)((AbstractExecutablePredicate)this.instance());
    }

    private record IndexedClassMatcher(@NotNull ClassPredicate matcher, @Nullable Integer index) implements Comparable<IndexedClassMatcher>
    {
        public IndexedClassMatcher(@NotNull ClassPredicate matcher) {
            this(matcher, null);
        }

        private static boolean all(@NotNull Class<?>[] classArray, @NotNull List<IndexedClassMatcher> classMatchers) {
            return classMatchers.stream().allMatch(matcher -> matcher.matches(classArray));
        }

        private static String toString(@NotNull List<IndexedClassMatcher> classMatchers) {
            return classMatchers.stream().sorted().map(IndexedClassMatcher::toString).collect(Collectors.joining(",\n    ", "{\n    ", "\n  }"));
        }

        public boolean matches(@NotNull Class<?>[] classArray) {
            if (this.index() == null) {
                for (Class<?> entry : classArray) {
                    if (!this.matcher().test(entry)) continue;
                    return true;
                }
                return false;
            }
            return this.index() < classArray.length && this.matcher().test(classArray[this.index()]);
        }

        @Override
        public int compareTo(@NotNull IndexedClassMatcher other) {
            if (this.index == null && other.index == null) {
                return 0;
            }
            if (this.index == null) {
                return -1;
            }
            if (other.index == null) {
                return 1;
            }
            return this.index.compareTo(other.index);
        }

        @Override
        @NotNull
        public String toString() {
            String key = this.index() == null ? "<any>" : this.index().toString();
            return String.format("%s=%s", key, this.matcher().requirement());
        }
    }
}

