/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.reflect.accessor;

import dev.imprex.orebfuscator.reflect.accessor.MethodAccessor;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.lang.runtime.ObjectMethods;
import net.imprex.shaded.org.jetbrains.annotations.NotNull;

final class DefaultMethodAccessor
extends Record
implements MethodAccessor {
    @NotNull
    private final Method member;
    @NotNull
    private final MethodHandle methodHandle;

    DefaultMethodAccessor(@NotNull Method member, @NotNull MethodHandle methodHandle) {
        this.member = member;
        this.methodHandle = methodHandle;
    }

    @Override
    public Object invoke(Object instance, Object ... args) {
        try {
            return this.methodHandle.invokeExact(instance, args);
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Unable to invoke method " + String.valueOf(this.member), throwable);
        }
    }

    @Override
    @NotNull
    public Method member() {
        return this.member;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{DefaultMethodAccessor.class, "member;methodHandle", "member", "methodHandle"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DefaultMethodAccessor.class, "member;methodHandle", "member", "methodHandle"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DefaultMethodAccessor.class, "member;methodHandle", "member", "methodHandle"}, this, o);
    }

    @NotNull
    public MethodHandle methodHandle() {
        return this.methodHandle;
    }
}

