/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.reflect.accessor;

import dev.imprex.orebfuscator.reflect.accessor.FieldAccessor;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.runtime.ObjectMethods;
import net.imprex.shaded.org.jetbrains.annotations.NotNull;
import net.imprex.shaded.org.jetbrains.annotations.Nullable;

final class DefaultFieldAccessor
extends Record
implements FieldAccessor {
    @NotNull
    private final Field member;
    @NotNull
    private final MethodHandle getterHandle;
    @Nullable
    private final MethodHandle setterHandle;

    DefaultFieldAccessor(@NotNull Field member, @NotNull MethodHandle getterHandle, @Nullable MethodHandle setterHandle) {
        this.member = member;
        this.getterHandle = getterHandle;
        this.setterHandle = setterHandle;
    }

    @Override
    public boolean readonly() {
        return this.setterHandle == null;
    }

    @Override
    public Object get(Object instance) {
        try {
            return this.getterHandle.invokeExact(instance);
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Unable to get field value of " + String.valueOf(this.member), throwable);
        }
    }

    @Override
    public void set(Object instance, Object value) {
        if (this.readonly()) {
            throw new IllegalStateException("Can't set value of trusted final field " + String.valueOf(this.member));
        }
        try {
            this.setterHandle.invokeExact(instance, value);
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Unable to set value of field " + String.valueOf(this.member), throwable);
        }
    }

    @Override
    @NotNull
    public Field member() {
        return this.member;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{DefaultFieldAccessor.class, "member;getterHandle;setterHandle", "member", "getterHandle", "setterHandle"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DefaultFieldAccessor.class, "member;getterHandle;setterHandle", "member", "getterHandle", "setterHandle"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DefaultFieldAccessor.class, "member;getterHandle;setterHandle", "member", "getterHandle", "setterHandle"}, this, o);
    }

    @NotNull
    public MethodHandle getterHandle() {
        return this.getterHandle;
    }

    @Nullable
    public MethodHandle setterHandle() {
        return this.setterHandle;
    }
}

