/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.reflect.accessor;

import dev.imprex.orebfuscator.reflect.accessor.ConstructorAccessor;
import dev.imprex.orebfuscator.reflect.accessor.DefaultConstructorAccessor;
import dev.imprex.orebfuscator.reflect.accessor.DefaultFieldAccessor;
import dev.imprex.orebfuscator.reflect.accessor.DefaultMethodAccessor;
import dev.imprex.orebfuscator.reflect.accessor.FieldAccessor;
import dev.imprex.orebfuscator.reflect.accessor.MethodAccessor;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import net.imprex.shaded.org.jetbrains.annotations.NotNull;

public final class Accessors {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final MethodType FIELD_GETTER = MethodType.methodType(Object.class, Object.class);
    private static final MethodType FIELD_SETTER = MethodType.methodType(Void.TYPE, Object.class, Object.class);

    private Accessors() {
    }

    @NotNull
    public static ConstructorAccessor wrap(@NotNull Constructor<?> constructor) {
        return Accessors.create(constructor, () -> {
            MethodHandle methodHandle = LOOKUP.unreflectConstructor(constructor);
            methodHandle = Accessors.generifyExecutable(methodHandle, false, true);
            return new DefaultConstructorAccessor(constructor, methodHandle);
        });
    }

    @NotNull
    public static FieldAccessor wrap(@NotNull Field field) {
        return Accessors.create(field, () -> {
            MethodHandle getter = LOOKUP.unreflectGetter(field);
            MethodHandle setter = null;
            try {
                setter = LOOKUP.unreflectSetter(field);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (Modifier.isStatic(field.getModifiers())) {
                getter = MethodHandles.dropArguments(getter, 0, new Class[]{Object.class});
                setter = setter != null ? MethodHandles.dropArguments(setter, 0, new Class[]{Object.class}) : null;
            }
            getter = getter.asType(FIELD_GETTER);
            setter = setter != null ? setter.asType(FIELD_SETTER) : null;
            return new DefaultFieldAccessor(field, getter, setter);
        });
    }

    @NotNull
    public static MethodAccessor wrap(@NotNull Method method) {
        return Accessors.create(method, () -> {
            MethodHandle methodHandle = LOOKUP.unreflect(method);
            methodHandle = Accessors.generifyExecutable(methodHandle, Modifier.isStatic(method.getModifiers()), false);
            return new DefaultMethodAccessor(method, methodHandle);
        });
    }

    @NotNull
    private static <TMember extends AccessibleObject, TAccessor> TAccessor create(@NotNull TMember member, @NotNull AccessorFactory<TAccessor> factory) {
        Objects.requireNonNull(member);
        boolean accessible = member.isAccessible();
        try {
            member.setAccessible(true);
            TAccessor TAccessor = factory.create();
            return TAccessor;
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to create accessor for " + String.valueOf(member), e);
        }
        finally {
            member.setAccessible(accessible);
        }
    }

    private static MethodHandle generifyExecutable(MethodHandle handle, boolean isStatic, boolean isConstructor) {
        MethodHandle target = handle.asFixedArity();
        int paramCount = handle.type().parameterCount() - (isConstructor || isStatic ? 0 : 1);
        target = target.asSpreader(Object[].class, paramCount);
        if (isStatic) {
            target = MethodHandles.dropArguments(target, 0, new Class[]{Object.class});
        }
        return target.asType(MethodType.genericMethodType(isConstructor ? 0 : 1, true));
    }

    private static interface AccessorFactory<T> {
        public T create() throws IllegalAccessException;
    }
}

