/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.reflect;

import dev.imprex.orebfuscator.reflect.accessor.Accessors;
import dev.imprex.orebfuscator.reflect.accessor.ConstructorAccessor;
import dev.imprex.orebfuscator.reflect.accessor.FieldAccessor;
import dev.imprex.orebfuscator.reflect.accessor.MethodAccessor;
import dev.imprex.orebfuscator.reflect.predicate.ConstructorPredicate;
import dev.imprex.orebfuscator.reflect.predicate.FieldPredicate;
import dev.imprex.orebfuscator.reflect.predicate.MethodPredicate;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.imprex.shaded.org.jetbrains.annotations.NotNull;

public class Reflector {
    @NotNull
    private final Class<?> target;
    @NotNull
    private Class<?> recursiveUntil;

    public static Reflector of(Class<?> target) {
        return new Reflector(target);
    }

    private Reflector(@NotNull Class<?> target) {
        this.target = Objects.requireNonNull(target);
        this.recursiveUntil = target;
    }

    public Reflector recursive() {
        return this.recursiveUntil(Object.class);
    }

    public Reflector recursiveUntil(Class<?> recursiveUntil) {
        this.recursiveUntil = recursiveUntil != null ? recursiveUntil : this.target;
        return this;
    }

    private String className() {
        if (this.target == this.recursiveUntil) {
            return this.target.getTypeName();
        }
        if (this.recursiveUntil == Object.class) {
            return String.format("%s recursively", this.target.getTypeName());
        }
        return String.format("%s recursively until %s", this.target.getTypeName(), this.recursiveUntil.getTypeName());
    }

    private <T> Stream<T> get(Function<Class<?>, T[]> getter) {
        Stream stream = Stream.empty();
        for (Class<?> current = this.target; current != null; current = current.getSuperclass()) {
            stream = Stream.concat(stream, Arrays.stream(getter.apply(current)));
            if (current == this.recursiveUntil) break;
        }
        return stream;
    }

    @NotNull
    public Stream<ConstructorAccessor> constructor(Predicate<Constructor<?>> predicate) {
        Stream<Constructor<?>> stream = this.get(Class::getDeclaredConstructors);
        return stream.filter(predicate).map(Accessors::wrap);
    }

    @NotNull
    public ConstructorPredicate constructor() {
        return new ConstructorPredicate(this::constructor, this::className);
    }

    @NotNull
    public Stream<FieldAccessor> field(Predicate<Field> predicate) {
        Stream<Field> stream = this.get(Class::getDeclaredFields);
        return stream.filter(predicate).map(Accessors::wrap);
    }

    @NotNull
    public FieldPredicate field() {
        return new FieldPredicate(this::field, this::className);
    }

    @NotNull
    public Stream<MethodAccessor> method(Predicate<Method> predicate) {
        Stream<Method> stream = this.get(Class::getDeclaredMethods);
        return stream.filter(predicate).map(Accessors::wrap);
    }

    @NotNull
    public MethodPredicate method() {
        return new MethodPredicate(this::method, this::className);
    }
}

