/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.config.yaml;

import dev.imprex.orebfuscator.config.yaml.ConfigurationSection;
import dev.imprex.orebfuscator.config.yaml.InvalidConfigurationException;
import dev.imprex.orebfuscator.config.yaml.NodeCommentData;
import dev.imprex.orebfuscator.config.yaml.YamlConstructor;
import dev.imprex.shaded.org.yaml.snakeyaml.DumperOptions;
import dev.imprex.shaded.org.yaml.snakeyaml.LoaderOptions;
import dev.imprex.shaded.org.yaml.snakeyaml.Yaml;
import dev.imprex.shaded.org.yaml.snakeyaml.constructor.BaseConstructor;
import dev.imprex.shaded.org.yaml.snakeyaml.error.YAMLException;
import dev.imprex.shaded.org.yaml.snakeyaml.nodes.AnchorNode;
import dev.imprex.shaded.org.yaml.snakeyaml.nodes.MappingNode;
import dev.imprex.shaded.org.yaml.snakeyaml.nodes.Node;
import dev.imprex.shaded.org.yaml.snakeyaml.nodes.NodeTuple;
import dev.imprex.shaded.org.yaml.snakeyaml.nodes.Tag;
import dev.imprex.shaded.org.yaml.snakeyaml.reader.UnicodeReader;
import dev.imprex.shaded.org.yaml.snakeyaml.representer.Representer;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import net.imprex.shaded.org.jetbrains.annotations.NotNull;
import net.imprex.shaded.org.jetbrains.annotations.Nullable;

public class YamlConfiguration
extends ConfigurationSection {
    private final DumperOptions dumperOptions = new DumperOptions();
    private final Representer representer = new Representer(this.dumperOptions);
    private final LoaderOptions loaderOptions = new LoaderOptions();
    private final YamlConstructor constructor = new YamlConstructor(this.loaderOptions);
    private final Yaml yaml = new Yaml((BaseConstructor)this.constructor, this.representer, this.dumperOptions, this.loaderOptions);
    private NodeCommentData commentData = new NodeCommentData();

    @NotNull
    public static YamlConfiguration loadConfig(@NotNull Path path) throws IOException, InvalidConfigurationException {
        Objects.requireNonNull(path, "Path cannot be null");
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfig(inputStream);
            return yamlConfiguration;
        }
    }

    @NotNull
    public static YamlConfiguration loadConfig(@NotNull InputStream inputStream) throws IOException, InvalidConfigurationException {
        YamlConfiguration yamlConfiguration;
        Objects.requireNonNull(inputStream, "InputStream cannot be null");
        UnicodeReader reader = new UnicodeReader(inputStream);
        try {
            YamlConfiguration configuration = new YamlConfiguration();
            configuration.load(reader);
            yamlConfiguration = configuration;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (YAMLException e) {
                throw new InvalidConfigurationException(e);
            }
        }
        ((Reader)reader).close();
        return yamlConfiguration;
    }

    protected YamlConfiguration() {
        super("");
        this.dumperOptions.setIndent(2);
        this.dumperOptions.setWidth(80);
        this.dumperOptions.setProcessComments(true);
        this.dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.representer.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.loaderOptions.setProcessComments(true);
    }

    public void clear() {
        this.map.clear();
    }

    public void save(@NotNull Path path) throws IOException {
        Objects.requireNonNull(path, "Path cannot be null");
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            this.dumperOptions.setProcessComments(true);
            this.save(writer);
        }
    }

    public String withoutComments() throws IOException {
        try (StringWriter writer = new StringWriter();){
            this.dumperOptions.setProcessComments(false);
            this.save(writer);
            String string = ((Object)writer).toString();
            return string;
        }
    }

    private void save(@NotNull Writer writer) throws IOException {
        Objects.requireNonNull(writer, "Writer cannot be null");
        MappingNode node = this.toNodeTree(this.commentData, this);
        this.commentData.apply(node);
        if (this.isNullOrEmpty(node.getBlockComments()) && this.isNullOrEmpty(node.getEndComments()) && node.getValue().isEmpty()) {
            writer.write("");
        } else {
            if (node.getValue().isEmpty()) {
                node.setFlowStyle(DumperOptions.FlowStyle.FLOW);
            }
            this.yaml.serialize(node, writer);
        }
    }

    private void load(@NotNull Reader reader) throws YAMLException, InvalidConfigurationException {
        Objects.requireNonNull(reader, "Reader cannot be null");
        Node rawNode = this.yaml.compose(reader);
        if (rawNode != null && !(rawNode instanceof MappingNode)) {
            throw new InvalidConfigurationException("Top level is not a Map.");
        }
        this.map.clear();
        MappingNode node = (MappingNode)rawNode;
        if (node != null) {
            this.commentData = new NodeCommentData(node);
            this.fromNodeTree(node, this.commentData, this);
        }
    }

    private MappingNode toNodeTree(@Nullable NodeCommentData commentData, @NotNull ConfigurationSection section) {
        ArrayList<NodeTuple> nodeTuples = new ArrayList<NodeTuple>();
        for (Map.Entry<String, Object> entry : section.map.entrySet()) {
            Node value;
            Object object;
            Node key = this.representer.represent(entry.getKey());
            NodeCommentData childCommentData = null;
            if (commentData != null) {
                childCommentData = commentData.getChild(entry.getKey());
            }
            if ((object = entry.getValue()) instanceof ConfigurationSection) {
                ConfigurationSection configurationSection = (ConfigurationSection)object;
                value = this.toNodeTree(childCommentData, configurationSection);
            } else {
                value = this.representer.represent(entry.getValue());
            }
            NodeTuple nodeTuple = new NodeTuple(key, value);
            if (childCommentData != null) {
                childCommentData.apply(nodeTuple);
            }
            nodeTuples.add(nodeTuple);
        }
        return new MappingNode(Tag.MAP, nodeTuples, DumperOptions.FlowStyle.BLOCK);
    }

    private void fromNodeTree(@NotNull MappingNode input, @NotNull NodeCommentData commentData, @NotNull ConfigurationSection section) throws InvalidConfigurationException {
        this.constructor.flattenMapping(input);
        for (NodeTuple nodeTuple : input.getValue()) {
            Node keyNode = nodeTuple.getKeyNode();
            String key = String.valueOf(this.constructor.constructObject(keyNode));
            if (key.isBlank() || key.indexOf(46) != -1) {
                throw new InvalidConfigurationException(String.format("Invalid key%s%n  key can't be blank or contain any '%s'", keyNode.getStartMark(), Character.valueOf('.')));
            }
            Node valueNode = nodeTuple.getValueNode();
            while (valueNode instanceof AnchorNode) {
                AnchorNode value = (AnchorNode)valueNode;
                valueNode = value.getRealNode();
            }
            NodeCommentData childCommentData = new NodeCommentData(nodeTuple);
            commentData.addChild(key, childCommentData);
            if (valueNode instanceof MappingNode) {
                MappingNode value = (MappingNode)valueNode;
                this.fromNodeTree(value, childCommentData, section.createSection(key));
                continue;
            }
            section.set(key, this.constructor.constructObject(valueNode));
        }
    }

    private boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }
}

