/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.config.migrations;

import dev.imprex.orebfuscator.config.migrations.ConfigMigration;
import dev.imprex.orebfuscator.config.migrations.ConfigMigrationV1;
import dev.imprex.orebfuscator.config.migrations.ConfigMigrationV2;
import dev.imprex.orebfuscator.config.migrations.ConfigMigrationV3;
import dev.imprex.orebfuscator.config.migrations.ConfigMigrationV4;
import dev.imprex.orebfuscator.config.yaml.ConfigurationSection;
import dev.imprex.orebfuscator.logging.OfcLogger;
import java.util.HashMap;
import java.util.Map;

public class ConfigMigrator {
    private static final Map<Integer, ConfigMigration> MIGRATIONS = new HashMap<Integer, ConfigMigration>();

    private static void register(ConfigMigration migration) {
        MIGRATIONS.put(migration.sourceVersion(), migration);
    }

    public static boolean willMigrate(ConfigurationSection root) {
        int version = root.getInt("version", -1);
        return MIGRATIONS.get(version) != null;
    }

    public static void migrateToLatestVersion(ConfigurationSection root) {
        while (true) {
            int sourceVersion = root.getInt("version", -1);
            int targetVersion = sourceVersion + 1;
            ConfigMigration migration = MIGRATIONS.get(sourceVersion);
            if (migration == null) break;
            OfcLogger.info("Starting to migrate config to version " + targetVersion);
            root = migration.migrate(root);
            root.set("version", targetVersion);
            OfcLogger.info("Successfully migrated config to version " + targetVersion);
        }
    }

    static {
        ConfigMigrator.register(new ConfigMigrationV1());
        ConfigMigrator.register(new ConfigMigrationV2());
        ConfigMigrator.register(new ConfigMigrationV3());
        ConfigMigrator.register(new ConfigMigrationV4());
    }
}

