/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.config.migrations;

import dev.imprex.orebfuscator.config.migrations.ConfigMigration;
import dev.imprex.orebfuscator.config.yaml.ConfigurationSection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.imprex.shaded.org.jetbrains.annotations.NotNull;

class ConfigMigrationV1
implements ConfigMigration {
    ConfigMigrationV1() {
    }

    @Override
    public int sourceVersion() {
        return 1;
    }

    @Override
    @NotNull
    public ConfigurationSection migrate(@NotNull ConfigurationSection root) {
        String obfuscationConfigPath = root.contains("world") ? "world" : "obfuscation";
        ConfigMigrationV1.convertSectionListToSection(root, obfuscationConfigPath);
        ConfigMigrationV1.convertSectionListToSection(root, "proximity");
        return root;
    }

    private static void convertSectionListToSection(ConfigurationSection root, String path) {
        List<ConfigurationSection> configList = ConfigMigrationV1.getSectionList(root, path);
        ConfigurationSection configContainer = root.createSection(path);
        for (ConfigurationSection config : configList) {
            configContainer.set(config.getName(), config);
        }
    }

    private static List<ConfigurationSection> getSectionList(ConfigurationSection root, String path) {
        ArrayList<ConfigurationSection> configList = new ArrayList<ConfigurationSection>();
        List<?> list = root.getList(path, Collections.emptyList());
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (!(obj instanceof Map)) continue;
            Map map = (Map)obj;
            ConfigurationSection config = root.createSection(path + "-" + i);
            configList.add(ConfigMigrationV1.convertMapsToSections(map, config));
        }
        return configList;
    }

    private static ConfigurationSection convertMapsToSections(Map<?, ?> entries, ConfigurationSection section) {
        for (Map.Entry<?, ?> entry : entries.entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map map = (Map)value;
                ConfigMigrationV1.convertMapsToSections(map, section.createSection(key));
                continue;
            }
            section.set(key, value);
        }
        return section;
    }
}

