/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.config.components;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.imprex.orebfuscator.util.BlockProperties;
import dev.imprex.orebfuscator.util.BlockTag;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.imprex.shaded.org.jetbrains.annotations.NotNull;

public record ConfigBlockValue(@NotNull String value, @NotNull Set<BlockProperties> blocks) implements Comparable<ConfigBlockValue>
{
    private static final JsonElement INVALID = new JsonPrimitive("invalid");
    private static final JsonElement VALID = new JsonPrimitive("valid");

    public static JsonObject toJson(Collection<? extends ConfigBlockValue> values) {
        JsonObject object = new JsonObject();
        List<? extends ConfigBlockValue> list = values.stream().sorted().toList();
        for (ConfigBlockValue configBlockValue : list) {
            if (configBlockValue.blocks().size() > 1) {
                JsonArray array = new JsonArray(configBlockValue.blocks().size());
                for (BlockProperties block : configBlockValue.blocks()) {
                    array.add(block.getKey().toString());
                }
                object.add(configBlockValue.value(), (JsonElement)array);
                continue;
            }
            if (configBlockValue.blocks().size() > 0) {
                object.add(configBlockValue.value(), VALID);
                continue;
            }
            object.add(configBlockValue.value(), INVALID);
        }
        return object;
    }

    @NotNull
    public static ConfigBlockValue invalid(@NotNull String value) {
        return new ConfigBlockValue(value, Collections.emptySet());
    }

    @NotNull
    public static ConfigBlockValue block(@NotNull BlockProperties block) {
        return new ConfigBlockValue(block.getKey().toString(), Set.of(block));
    }

    @NotNull
    public static ConfigBlockValue invalidTag(@NotNull String value) {
        return new ConfigBlockValue(String.format("tag(%s)", value), Collections.emptySet());
    }

    @NotNull
    public static ConfigBlockValue tag(@NotNull BlockTag tag, @NotNull Set<BlockProperties> blocks) {
        return new ConfigBlockValue(String.format("tag(%s)", tag.key()), Collections.unmodifiableSet(blocks));
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof ConfigBlockValue)) return false;
        ConfigBlockValue other = (ConfigBlockValue)obj;
        if (!Objects.equals(this.value, other.value)) return false;
        return true;
    }

    @Override
    public int compareTo(ConfigBlockValue o) {
        boolean isBTag;
        boolean isATag = this.value().startsWith("tag(");
        int tag = Boolean.compare(isATag, isBTag = o.value().startsWith("tag("));
        if (tag == 0) {
            return this.value().compareTo(o.value());
        }
        return tag;
    }
}

