/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.config;

public class ProximityHeightCondition {
    public static final int MATCH_ALL = ProximityHeightCondition.create(-2032, 2031);

    public static int clampY(int y) {
        return Math.min(2031, Math.max(-2032, y));
    }

    private static int unsigned(int y) {
        return ProximityHeightCondition.clampY(y) - -2032 & 0xFFF;
    }

    private static int signed(int y) {
        return y + -2032;
    }

    public static int create(int minY, int maxY) {
        return ProximityHeightCondition.unsigned(minY) << 20 | ProximityHeightCondition.unsigned(maxY) << 8 | 0x80;
    }

    public static int remove(int hideCondition) {
        return hideCondition & 0x7F;
    }

    private static int extractHideCondition(int hideCondition) {
        return hideCondition & 0xFFFFFF80;
    }

    public static boolean equals(int a, int b) {
        return ProximityHeightCondition.extractHideCondition(a) == ProximityHeightCondition.extractHideCondition(b);
    }

    public static boolean match(int hideCondition, int y) {
        return ProximityHeightCondition.isPresent(hideCondition) && ProximityHeightCondition.getMinY(hideCondition) <= y && ProximityHeightCondition.getMaxY(hideCondition) >= y;
    }

    public static boolean isPresent(int hideCondition) {
        return (hideCondition & 0x80) != 0;
    }

    public static int getMinY(int hideCondition) {
        return ProximityHeightCondition.signed(hideCondition >>> 20);
    }

    public static int getMaxY(int hideCondition) {
        return ProximityHeightCondition.signed(hideCondition << 12 >>> 20);
    }
}

