/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.imprex.orebfuscator.config.AbstractWorldConfig;
import dev.imprex.orebfuscator.config.ProximityHeightCondition;
import dev.imprex.orebfuscator.config.api.BlockFlags;
import dev.imprex.orebfuscator.config.api.ProximityConfig;
import dev.imprex.orebfuscator.config.components.BlockParser;
import dev.imprex.orebfuscator.config.components.ConfigBlockValue;
import dev.imprex.orebfuscator.config.components.WeightedBlockList;
import dev.imprex.orebfuscator.config.context.ConfigMessage;
import dev.imprex.orebfuscator.config.context.ConfigParsingContext;
import dev.imprex.orebfuscator.config.yaml.ConfigurationSection;
import dev.imprex.orebfuscator.util.BlockProperties;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.imprex.shaded.org.joml.Matrix4f;

public class OrebfuscatorProximityConfig
extends AbstractWorldConfig
implements ProximityConfig {
    private int distance = 24;
    private boolean frustumCullingEnabled = true;
    private float frustumCullingMinDistance = 3.0f;
    private float frustumCullingFov = 80.0f;
    private float frustumCullingMinDistanceSquared = 9.0f;
    private final Matrix4f frustumCullingProjectionMatrix;
    private boolean rayCastCheckEnabled = false;
    private boolean rayCastCheckOnlyCheckCenter = false;
    private int defaultBlockFlags = ProximityHeightCondition.MATCH_ALL | 8;
    private boolean usesBlockSpecificConfigs = false;
    private final Map<ConfigBlockValue, Integer> hiddenBlocks = new LinkedHashMap<ConfigBlockValue, Integer>();
    private final Set<BlockProperties> allowForUseBlockBelow = new HashSet<BlockProperties>();

    OrebfuscatorProximityConfig(BlockParser.Factory blockParserFactory, ConfigurationSection section, ConfigParsingContext context) {
        super(section.getName());
        this.deserializeBase(section, context);
        this.distance = section.getInt("distance", 24);
        context.errorMinValue("distance", 1L, this.distance);
        this.frustumCullingEnabled = section.getBoolean("frustumCulling.enabled", false);
        this.frustumCullingMinDistance = section.getDouble("frustumCulling.minDistance", 3.0).floatValue();
        this.frustumCullingFov = section.getDouble("frustumCulling.fov", 80.0).floatValue();
        if (this.frustumCullingEnabled) {
            context.errorMinMaxValue("frustumCulling.fov", 10L, 170L, (int)this.frustumCullingFov);
        }
        this.frustumCullingMinDistanceSquared = this.frustumCullingMinDistance * this.frustumCullingMinDistance;
        this.frustumCullingProjectionMatrix = new Matrix4f().perspective(this.frustumCullingFov, 1.7777778f, 0.01f, 2 * this.distance);
        this.rayCastCheckEnabled = section.getBoolean("rayCastCheck.enabled", false);
        this.rayCastCheckOnlyCheckCenter = section.getBoolean("rayCastCheck.onlyCheckCenter", false);
        this.defaultBlockFlags = ProximityHeightCondition.create(this.minY, this.maxY);
        if (section.getBoolean("useBlockBelow", true).booleanValue()) {
            this.defaultBlockFlags |= 8;
        }
        this.deserializeHiddenBlocks(blockParserFactory, section, context);
        this.deserializeRandomBlocks(blockParserFactory, section, context);
        for (WeightedBlockList blockList : this.weightedBlockLists) {
            this.allowForUseBlockBelow.addAll(blockList.getBlocks().stream().flatMap(value -> value.blocks().stream()).toList());
        }
        this.disableOnError(context);
    }

    protected void serialize(ConfigurationSection section) {
        this.serializeBase(section);
        section.set("distance", this.distance);
        section.set("frustumCulling.enabled", this.frustumCullingEnabled);
        section.set("frustumCulling.minDistance", Float.valueOf(this.frustumCullingMinDistance));
        section.set("frustumCulling.fov", Float.valueOf(this.frustumCullingFov));
        section.set("rayCastCheck.enabled", this.rayCastCheckEnabled);
        section.set("rayCastCheck.onlyCheckCenter", this.rayCastCheckOnlyCheckCenter);
        section.set("useBlockBelow", BlockFlags.isUseBlockBelowBitSet(this.defaultBlockFlags));
        this.serializeHiddenBlocks(section);
        this.serializeRandomBlocks(section);
    }

    private void deserializeHiddenBlocks(BlockParser.Factory blockParserFactory, ConfigurationSection section, ConfigParsingContext context) {
        context = context.section("hiddenBlocks");
        ConfigurationSection blockSection = section.getSection("hiddenBlocks");
        if (blockSection == null) {
            return;
        }
        BlockParser blockParser = blockParserFactory.excludeAir();
        boolean isEmpty = true;
        for (ConfigurationSection block : blockSection.getSubSections()) {
            ConfigBlockValue parsed = blockParser.parse(context, block.getName());
            int blockFlags = this.defaultBlockFlags;
            if (block.isNumber("minY") && block.isNumber("maxY")) {
                int minY = block.getInt("minY", this.minY);
                int maxY = block.getInt("maxY", this.maxY);
                blockFlags = ProximityHeightCondition.remove(blockFlags);
                blockFlags |= ProximityHeightCondition.create(Math.min(minY, maxY), Math.max(minY, maxY));
                this.usesBlockSpecificConfigs = true;
            }
            if (block.isBoolean("useBlockBelow")) {
                blockFlags = block.getBoolean("useBlockBelow", true).booleanValue() ? (blockFlags |= 8) : (blockFlags &= 0xFFFFFFF7);
                this.usesBlockSpecificConfigs = true;
            }
            this.hiddenBlocks.put(parsed, blockFlags);
            isEmpty &= parsed.blocks().isEmpty();
        }
        if (isEmpty) {
            context.error(ConfigMessage.MISSING_OR_EMPTY, new Object[0]);
        }
    }

    private void serializeHiddenBlocks(ConfigurationSection section) {
        ConfigurationSection blockSection = section.createSection("hiddenBlocks");
        for (Map.Entry<ConfigBlockValue, Integer> entry : this.hiddenBlocks.entrySet()) {
            ConfigurationSection block = blockSection.createSection(entry.getKey().value());
            int blockFlags = entry.getValue();
            if (!ProximityHeightCondition.equals(blockFlags, this.defaultBlockFlags)) {
                block.set("minY", ProximityHeightCondition.getMinY(blockFlags));
                block.set("maxY", ProximityHeightCondition.getMaxY(blockFlags));
            }
            if (BlockFlags.isUseBlockBelowBitSet(blockFlags) == BlockFlags.isUseBlockBelowBitSet(this.defaultBlockFlags)) continue;
            block.set("useBlockBelow", BlockFlags.isUseBlockBelowBitSet(blockFlags));
        }
    }

    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        object.add("hiddenBlocks", (JsonElement)ConfigBlockValue.toJson(this.hiddenBlocks.keySet()));
        object.add("randomBlocks", (JsonElement)this.randomBlocksToJson());
        return object;
    }

    @Override
    public int distance() {
        return this.distance;
    }

    @Override
    public boolean frustumCullingEnabled() {
        return this.frustumCullingEnabled;
    }

    @Override
    public float frustumCullingMinDistanceSquared() {
        return this.frustumCullingMinDistanceSquared;
    }

    @Override
    public Matrix4f frustumCullingProjectionMatrix() {
        return new Matrix4f(this.frustumCullingProjectionMatrix);
    }

    @Override
    public boolean rayCastCheckEnabled() {
        return this.rayCastCheckEnabled;
    }

    @Override
    public boolean rayCastCheckOnlyCheckCenter() {
        return this.rayCastCheckOnlyCheckCenter;
    }

    @Override
    public Iterable<Map.Entry<ConfigBlockValue, Integer>> hiddenBlocks() {
        return this.hiddenBlocks.entrySet();
    }

    public Iterable<BlockProperties> allowForUseBlockBelow() {
        return this.allowForUseBlockBelow;
    }

    boolean usesBlockSpecificConfigs() {
        return this.usesBlockSpecificConfigs;
    }
}

