/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.config;

import dev.imprex.orebfuscator.config.OrebfuscatorObfuscationConfig;
import dev.imprex.orebfuscator.config.OrebfuscatorProximityConfig;
import dev.imprex.orebfuscator.config.ProximityHeightCondition;
import dev.imprex.orebfuscator.config.api.BlockFlags;
import dev.imprex.orebfuscator.config.components.ConfigBlockValue;
import dev.imprex.orebfuscator.interop.RegistryAccessor;
import dev.imprex.orebfuscator.util.BlockProperties;
import dev.imprex.orebfuscator.util.BlockStateProperties;
import java.util.Map;

public class OrebfuscatorBlockFlags
implements BlockFlags {
    private static final BlockFlags EMPTY_FLAGS = new EmptyBlockFlags();
    private final int[] blockFlags;

    static BlockFlags create(RegistryAccessor registry, OrebfuscatorObfuscationConfig worldConfig, OrebfuscatorProximityConfig proximityConfig) {
        if (worldConfig != null && worldConfig.isEnabled() || proximityConfig != null && proximityConfig.isEnabled()) {
            return new OrebfuscatorBlockFlags(registry, worldConfig, proximityConfig);
        }
        return EMPTY_FLAGS;
    }

    private OrebfuscatorBlockFlags(RegistryAccessor registry, OrebfuscatorObfuscationConfig worldConfig, OrebfuscatorProximityConfig proximityConfig) {
        this.blockFlags = new int[registry.getUniqueBlockStateCount()];
        if (worldConfig != null && worldConfig.isEnabled()) {
            for (ConfigBlockValue configBlockValue : worldConfig.hiddenBlocks()) {
                for (BlockProperties block : configBlockValue.blocks()) {
                    this.setBlockBits(block, 1);
                }
            }
        }
        if (proximityConfig != null && proximityConfig.isEnabled()) {
            for (Map.Entry entry : proximityConfig.hiddenBlocks()) {
                for (BlockProperties block : ((ConfigBlockValue)entry.getKey()).blocks()) {
                    this.setBlockBits(block, (Integer)entry.getValue());
                }
            }
            for (BlockProperties blockProperties : proximityConfig.allowForUseBlockBelow()) {
                this.setBlockBits(blockProperties, 16);
            }
        }
    }

    private void setBlockBits(BlockProperties block, int bits) {
        for (BlockStateProperties blockState : block.getBlockStates()) {
            int blockMask = this.blockFlags[blockState.getId()] | bits;
            if (blockState.isBlockEntity()) {
                blockMask |= 2;
            }
            this.blockFlags[blockState.getId()] = blockMask;
        }
    }

    @Override
    public int flags(int blockState) {
        return this.blockFlags[blockState];
    }

    @Override
    public int flags(int blockState, int y) {
        int flags = this.blockFlags[blockState];
        if (ProximityHeightCondition.match(flags, y)) {
            flags |= 4;
        }
        return flags;
    }

    private static class EmptyBlockFlags
    implements BlockFlags {
        private EmptyBlockFlags() {
        }

        @Override
        public int flags(int blockState) {
            return 0;
        }

        @Override
        public int flags(int blockState, int y) {
            return 0;
        }
    }
}

