/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.config;

import dev.imprex.orebfuscator.config.api.AdvancedConfig;
import dev.imprex.orebfuscator.config.context.ConfigMessage;
import dev.imprex.orebfuscator.config.context.ConfigParsingContext;
import dev.imprex.orebfuscator.config.yaml.ConfigurationSection;
import dev.imprex.orebfuscator.logging.OfcLogger;

public class OrebfuscatorAdvancedConfig
implements AdvancedConfig {
    private boolean verbose = false;
    private int obfuscationThreads = -1;
    private long obfuscationTimeout = 10000L;
    private int maxMillisecondsPerTick = 10;
    private int proximityThreads = -1;
    private int proximityDefaultBucketSize = 50;
    private int proximityThreadCheckInterval = 50;
    private int proximityPlayerCheckInterval = 5000;
    private boolean obfuscationThreadsSet = false;
    private boolean hasObfuscationTimeout = false;
    private boolean proximityThreadsSet = false;
    private boolean hasProximityPlayerCheckInterval = true;

    public void deserialize(ConfigurationSection section, ConfigParsingContext context) {
        this.verbose = section.getBoolean("verbose", false);
        ConfigParsingContext obfuscationContext = context.section("obfuscation");
        ConfigurationSection obfuscationSection = section.getSection("obfuscation");
        if (obfuscationSection != null) {
            this.obfuscationThreads = obfuscationSection.getInt("threads", -1);
            this.obfuscationThreadsSet = this.obfuscationThreads > 0;
            this.obfuscationTimeout = obfuscationSection.getLong("timeout", 10000L);
            this.hasObfuscationTimeout = this.obfuscationTimeout > 0L;
            this.maxMillisecondsPerTick = obfuscationSection.getInt("maxMillisecondsPerTick", 10);
            obfuscationContext.errorMinMaxValue("maxMillisecondsPerTick", 1L, 50L, this.maxMillisecondsPerTick);
        } else {
            obfuscationContext.warn(ConfigMessage.MISSING_USING_DEFAULTS, new Object[0]);
        }
        ConfigParsingContext proximityContext = context.section("proximity");
        ConfigurationSection proximitySection = section.getSection("proximity");
        if (proximitySection != null) {
            this.proximityThreads = proximitySection.getInt("threads", -1);
            this.proximityThreadsSet = this.proximityThreads > 0;
            this.proximityDefaultBucketSize = proximitySection.getInt("defaultBucketSize", 50);
            proximityContext.errorMinValue("defaultBucketSize", 1L, this.proximityDefaultBucketSize);
            this.proximityThreadCheckInterval = proximitySection.getInt("threadCheckInterval", 50);
            proximityContext.errorMinValue("threadCheckInterval", 1L, this.proximityThreadCheckInterval);
            this.proximityPlayerCheckInterval = proximitySection.getInt("playerCheckInterval", 5000);
            this.hasProximityPlayerCheckInterval = this.proximityPlayerCheckInterval > 0;
        } else {
            proximityContext.warn(ConfigMessage.MISSING_USING_DEFAULTS, new Object[0]);
        }
        int availableThreads = Runtime.getRuntime().availableProcessors();
        this.obfuscationThreads = this.obfuscationThreadsSet ? this.obfuscationThreads : availableThreads;
        this.proximityThreads = (int)(this.proximityThreadsSet ? (double)this.proximityThreads : Math.ceil((float)availableThreads / 2.0f));
        OfcLogger.setVerboseLogging(this.verbose);
        OfcLogger.debug("advanced.obfuscationThreads = " + this.obfuscationThreads);
        OfcLogger.debug("advanced.proximityThreads = " + this.proximityThreads);
    }

    public void serialize(ConfigurationSection section) {
        section.set("verbose", this.verbose);
        section.set("obfuscation.threads", this.obfuscationThreadsSet ? this.obfuscationThreads : -1);
        section.set("obfuscation.timeout", this.hasObfuscationTimeout ? this.obfuscationTimeout : -1L);
        section.set("obfuscation.maxMillisecondsPerTick", this.maxMillisecondsPerTick);
        section.set("proximity.threads", this.proximityThreadsSet ? this.proximityThreads : -1);
        section.set("proximity.defaultBucketSize", this.proximityDefaultBucketSize);
        section.set("proximity.threadCheckInterval", this.proximityThreadCheckInterval);
        section.set("proximity.playerCheckInterval", this.hasProximityPlayerCheckInterval ? this.proximityPlayerCheckInterval : -1);
    }

    @Override
    public int obfuscationThreads() {
        return this.obfuscationThreads;
    }

    @Override
    public boolean hasObfuscationTimeout() {
        return this.hasObfuscationTimeout;
    }

    @Override
    public long obfuscationTimeout() {
        return this.obfuscationTimeout;
    }

    @Override
    public int maxMillisecondsPerTick() {
        return this.maxMillisecondsPerTick;
    }

    @Override
    public int proximityThreads() {
        return this.proximityThreads;
    }

    @Override
    public int proximityDefaultBucketSize() {
        return this.proximityDefaultBucketSize;
    }

    @Override
    public int proximityThreadCheckInterval() {
        return this.proximityThreadCheckInterval;
    }

    @Override
    public boolean hasProximityPlayerCheckInterval() {
        return this.hasProximityPlayerCheckInterval;
    }

    @Override
    public int proximityPlayerCheckInterval() {
        return this.proximityPlayerCheckInterval;
    }
}

