/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.config;

import dev.imprex.orebfuscator.util.Version;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class ConfigLookup {
    private static final Pattern FILENAME_PATTERN = Pattern.compile("config-(?<version>.*)\\.yml");

    public static Version getConfigVersion(Version version) throws IOException {
        List<Version> versions = ConfigLookup.discoverConfigs().stream().map(FILENAME_PATTERN::matcher).filter(Matcher::find).map(m -> m.group("version")).map(Version::tryParse).filter(Optional::isPresent).map(Optional::get).sorted(Comparator.reverseOrder()).toList();
        for (Version configVersion : versions) {
            if (!version.isAtOrAbove(configVersion)) continue;
            return configVersion;
        }
        return null;
    }

    public static InputStream loadConfig(Version version) {
        String path = String.format("/config/config-%s.yml", version);
        return ConfigLookup.class.getResourceAsStream(path);
    }

    private static List<String> discoverConfigs() throws IOException {
        Path baseDir;
        URL location;
        ProtectionDomain protectionDomain = ConfigLookup.class.getProtectionDomain();
        CodeSource codeSource = protectionDomain != null ? protectionDomain.getCodeSource() : null;
        URL uRL = location = codeSource != null ? codeSource.getLocation() : null;
        if (location == null) {
            return Collections.emptyList();
        }
        if (location.getPath().endsWith(".jar")) {
            URI jar = URI.create("jar:" + String.valueOf(location));
            try (FileSystem fileSystem = FileSystems.newFileSystem(jar, Map.of());){
                List<String> list;
                block24: {
                    Path configDir = fileSystem.getPath("/config/", new String[0]);
                    if (!Files.isDirectory(configDir, new LinkOption[0])) {
                        List<String> list2 = Collections.emptyList();
                        return list2;
                    }
                    Stream<Path> stream = Files.list(configDir);
                    try {
                        list = stream.map(configDir::relativize).map(Path::toString).toList();
                        if (stream == null) break block24;
                    }
                    catch (Throwable throwable) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stream.close();
                }
                return list;
            }
        }
        Path jarDir = Paths.get(URI.create(location.toString()));
        if (!Files.isDirectory(jarDir, new LinkOption[0])) {
            return Collections.emptyList();
        }
        Path path = baseDir = jarDir.endsWith("build/classes/java/main/") ? jarDir.resolve("../../../resources/main/config").normalize() : jarDir.resolve("config/");
        if (!Files.isDirectory(baseDir, new LinkOption[0])) {
            return Collections.emptyList();
        }
        try (Stream<Path> stream = Files.list(baseDir);){
            List<String> list = stream.map(baseDir::relativize).map(Path::toString).toList();
            return list;
        }
    }
}

