/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.imprex.orebfuscator.config.api.WorldConfig;
import dev.imprex.orebfuscator.config.components.BlockParser;
import dev.imprex.orebfuscator.config.components.ConfigBlockValue;
import dev.imprex.orebfuscator.config.components.WeightedBlockList;
import dev.imprex.orebfuscator.config.components.WorldMatcher;
import dev.imprex.orebfuscator.config.context.ConfigMessage;
import dev.imprex.orebfuscator.config.context.ConfigParsingContext;
import dev.imprex.orebfuscator.config.yaml.ConfigurationSection;
import dev.imprex.orebfuscator.interop.WorldAccessor;
import dev.imprex.orebfuscator.logging.OfcLogger;
import dev.imprex.orebfuscator.util.MathUtil;
import dev.imprex.orebfuscator.util.WeightedRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractWorldConfig
implements WorldConfig {
    private final String name;
    protected boolean enabledValue = false;
    protected boolean enabled = false;
    protected int minY = -2032;
    protected int maxY = 2031;
    protected final List<WorldMatcher> worldMatchers = new ArrayList<WorldMatcher>();
    protected final List<WeightedBlockList> weightedBlockLists = new ArrayList<WeightedBlockList>();

    public AbstractWorldConfig(String name) {
        this.name = name;
    }

    protected void deserializeBase(ConfigurationSection section, ConfigParsingContext context) {
        this.enabledValue = section.getBoolean("enabled", true);
        int minY = MathUtil.clamp(section.getInt("minY", -2032), -2032, 2031);
        int maxY = MathUtil.clamp(section.getInt("maxY", 2031), -2032, 2031);
        this.minY = Math.min(minY, maxY);
        this.maxY = Math.max(minY, maxY);
        section.getStringList("worlds").stream().map(WorldMatcher::parseMatcher).forEach(this.worldMatchers::add);
        if (this.worldMatchers.isEmpty()) {
            context.section("worlds").error(ConfigMessage.MISSING_OR_EMPTY, new Object[0]);
        }
    }

    protected void serializeBase(ConfigurationSection section) {
        section.set("enabled", this.enabledValue);
        section.set("minY", this.minY);
        section.set("maxY", this.maxY);
        section.set("worlds", this.worldMatchers.stream().map(WorldMatcher::serialize).collect(Collectors.toList()));
    }

    protected void deserializeRandomBlocks(BlockParser.Factory blockParserFactory, ConfigurationSection section, ConfigParsingContext context) {
        context = context.section("randomBlocks");
        ConfigurationSection subSectionContainer = section.getSection("randomBlocks");
        if (subSectionContainer == null) {
            context.error(ConfigMessage.MISSING_OR_EMPTY, new Object[0]);
            return;
        }
        for (ConfigurationSection subSection : subSectionContainer.getSubSections()) {
            ConfigParsingContext subContext = context.section(subSection.getName());
            this.weightedBlockLists.add(new WeightedBlockList(blockParserFactory, subSection, subContext));
        }
        if (this.weightedBlockLists.isEmpty()) {
            context.error(ConfigMessage.MISSING_OR_EMPTY, new Object[0]);
        }
    }

    protected void serializeRandomBlocks(ConfigurationSection section) {
        ConfigurationSection subSectionContainer = section.createSection("randomBlocks");
        for (WeightedBlockList weightedBlockList : this.weightedBlockLists) {
            weightedBlockList.serialize(subSectionContainer);
        }
    }

    protected void disableOnError(ConfigParsingContext context) {
        this.enabled = context.disableIfError(this.enabledValue);
    }

    protected String getName() {
        return this.name;
    }

    public JsonObject randomBlocksToJson() {
        JsonObject object = new JsonObject();
        for (WeightedBlockList list : this.weightedBlockLists) {
            object.add(list.getName(), (JsonElement)ConfigBlockValue.toJson(list.getBlocks()));
        }
        return object;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public int getMinY() {
        return this.minY;
    }

    @Override
    public int getMaxY() {
        return this.maxY;
    }

    @Override
    public boolean matchesWorldName(String worldName) {
        for (WorldMatcher matcher : this.worldMatchers) {
            if (!matcher.test(worldName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldObfuscate(int y) {
        return y >= this.minY && y <= this.maxY;
    }

    WeightedRandom[] createWeightedRandoms(WorldAccessor world) {
        OfcLogger.debug(String.format("Creating weighted randoms for %s for world %s:", this.name, world));
        return WeightedBlockList.create(world, this.weightedBlockLists);
    }
}

