/*
 * Decompiled with CFR 0.152.
 */
package it.icewolf23x.plugins.oreextraction.events;

import it.icewolf23x.plugins.oreextraction.OreExtraction;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class BlockBreakEventListener
implements Listener {
    String[] stone = new String[]{"copper_ore", "lapis_ore", "redstone_ore", "diamond_ore", "coal_ore", "iron_ore", "gold_ore", "emerald_ore"};
    String[] deepslate = new String[]{"deepslate_copper_ore", "deepslate_lapis_ore", "deepslate_redstone_ore", "deepslate_diamond_ore", "deepslate_coal_ore", "deepslate_iron_ore", "deepslate_gold_ore", "deepslate_emerald_ore"};
    String[] netherrack = new String[]{"nether_gold_ore", "nether_quartz_ore"};

    public BlockBreakEventListener(OreExtraction plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void consumeDurability(Player player) {
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        Damageable itemMeta = (Damageable)mainHand.getItemMeta();
        if (itemMeta != null) {
            itemMeta.setDamage(itemMeta.getDamage() + 1);
            if (itemMeta.hasMaxDamage()) {
                if (itemMeta.getDamage() >= itemMeta.getMaxDamage()) {
                    player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
                }
            } else if (itemMeta.getDamage() >= mainHand.getType().getMaxDurability()) {
                player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
            }
            mainHand.setItemMeta((ItemMeta)itemMeta);
        }
    }

    public void replaceBlock(Player player, Block block, Material replacement, Collection<ItemStack> drops) {
        block.setType(replacement);
        Location loc = block.getLocation().clone();
        RayTraceResult trace = player.getLocation().getWorld().rayTraceBlocks(player.getEyeLocation(), player.getEyeLocation().getDirection(), 10.0, FluidCollisionMode.NEVER);
        if (trace == null || trace.getHitBlockFace() == null) {
            for (ItemStack item : drops) {
                block.getWorld().dropItemNaturally(block.getLocation(), item);
            }
            return;
        }
        switch (trace.getHitBlockFace()) {
            case SOUTH: {
                loc.add(new Vector(0.0, 0.0, 0.75));
                break;
            }
            case NORTH: {
                loc.add(new Vector(0.0, 0.0, -0.75));
                break;
            }
            case EAST: {
                loc.add(new Vector(0.75, 0.0, 0.0));
                break;
            }
            case WEST: {
                loc.add(new Vector(-0.75, 0.0, 0.0));
                break;
            }
            case UP: {
                loc.add(new Vector(0.0, 0.75, 0.0));
                break;
            }
            case DOWN: {
                loc.add(new Vector(0.0, -0.75, 0.0));
                break;
            }
            default: {
                return;
            }
        }
        for (ItemStack item : drops) {
            block.getWorld().dropItemNaturally(loc, item);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("oreextraction.use")) {
            return;
        }
        if (player.getGameMode().equals((Object)GameMode.CREATIVE)) {
            return;
        }
        if (!player.getInventory().getItemInMainHand().getType().toString().contains("PICKAXE")) {
            return;
        }
        if (player.getInventory().getItemInMainHand().getEnchantments().containsKey(Enchantment.SILK_TOUCH)) {
            return;
        }
        String blockId = event.getBlock().getType().toString().toLowerCase();
        Collection drops = event.getBlock().getDrops(player.getInventory().getItemInMainHand());
        if (Arrays.asList(this.stone).contains(blockId)) {
            this.replaceBlock(player, event.getBlock(), Material.COBBLESTONE, drops);
            this.consumeDurability(player);
            event.setCancelled(true);
        }
        if (Arrays.asList(this.deepslate).contains(blockId)) {
            this.replaceBlock(player, event.getBlock(), Material.COBBLED_DEEPSLATE, drops);
            this.consumeDurability(player);
            event.setCancelled(true);
        }
        if (Arrays.asList(this.netherrack).contains(blockId)) {
            this.replaceBlock(player, event.getBlock(), Material.NETHERRACK, drops);
            this.consumeDurability(player);
            event.setCancelled(true);
        }
    }
}

