/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.storage.persistence;

import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class Settlement {
    private UUID owner;
    private String tag;
    private String description;
    private String defaultRole;
    private Location location;
    private Material icon;
    private int maxLand;
    private int maxCitizens;
    private int maxRoles;

    public static Settlement create(Player player) {
        return new Settlement(player);
    }

    public Settlement(Player player) {
        this.owner = player.getUniqueId();
        this.maxCitizens = 10;
        this.maxLand = 15;
        this.maxRoles = 5;
        this.description = "A peaceful place.";
        this.location = player.getLocation();
    }

    public void setOwner(OfflinePlayer offlinePlayer) {
        this.owner = offlinePlayer.getUniqueId();
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void setMaxCitizens(int maxCitizens) {
        this.maxCitizens = maxCitizens;
    }

    public void setMaxLand(int maxLand) {
        this.maxLand = maxLand;
    }

    public void setMaxRoles(int maxRoles) {
        this.maxRoles = maxRoles;
    }

    public void setDefaultRole(String defaultRole) {
        this.defaultRole = defaultRole;
    }

    public void setIcon(Material icon) {
        this.icon = icon;
    }

    public boolean isOwner(OfflinePlayer offlinePlayer) {
        return this.owner.equals(offlinePlayer.getUniqueId());
    }

    public Location getLocation() {
        return this.location;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOwnerName() {
        OfflinePlayer player = Arrays.stream(Bukkit.getOfflinePlayers()).filter(offlinePlayer -> offlinePlayer.getUniqueId().equals(this.owner)).findFirst().orElse(null);
        if (player != null) {
            return player.getName();
        }
        return null;
    }

    public int getMaxLand() {
        return this.maxLand;
    }

    public int getMaxCitizens() {
        return this.maxCitizens;
    }

    public String getDefaultRole() {
        return this.defaultRole;
    }

    public int getMaxRoles() {
        return this.maxRoles;
    }

    public Material getIcon() {
        return this.icon;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Settlement)) {
            return false;
        }
        Settlement that = (Settlement)o;
        return this.maxLand == that.maxLand && this.maxCitizens == that.maxCitizens && this.maxRoles == that.maxRoles && Objects.equals(this.owner, that.owner) && Objects.equals(this.tag, that.tag) && Objects.equals(this.description, that.description) && Objects.equals(this.defaultRole, that.defaultRole) && Objects.equals(this.location, that.location) && this.icon == that.icon;
    }

    public int hashCode() {
        return Objects.hash(this.owner, this.tag, this.description, this.defaultRole, this.location, this.icon, this.maxLand, this.maxCitizens, this.maxRoles);
    }
}

