/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.storage.persistence;

import com.huskydreaming.huskycore.utilities.Util;
import com.huskydreaming.settlements.enumeration.RolePermission;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Role {
    private final String name;
    private final Set<RolePermission> permissions;

    public static Role create(String name) {
        return new Role(name);
    }

    public Role(String name) {
        this.name = name;
        this.permissions = new HashSet<RolePermission>();
    }

    public void add(RolePermission permission) {
        this.permissions.add(permission);
    }

    public void remove(RolePermission permission) {
        this.permissions.remove(permission);
    }

    public boolean hasPermission(RolePermission permission) {
        return this.permissions.contains(permission);
    }

    public String getName() {
        return Util.capitalize(this.name.toLowerCase());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Role)) {
            return false;
        }
        Role role = (Role)o;
        return Objects.equals(this.name, role.name) && Objects.equals(this.permissions, role.permissions);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.permissions);
    }
}

