/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.storage.persistence;

import com.huskydreaming.settlements.enumeration.Flag;
import com.huskydreaming.settlements.enumeration.RolePermission;
import com.huskydreaming.settlements.enumeration.types.NotificationType;
import com.huskydreaming.settlements.enumeration.types.SettlementDefaultType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.World;

public class Config {
    private boolean trusting;
    private boolean teleportation;
    private boolean homes;
    private String emptyPlaceholder;
    private NotificationType notificationType;
    private List<String> disabledWorlds;
    private List<Flag> flags;
    private Map<String, List<RolePermission>> defaultRoles;
    private Map<SettlementDefaultType, Integer> settlementDefaults;

    public boolean containsDisableWorld(World world) {
        return this.disabledWorlds.contains(world.getName());
    }

    public void addDisabledWorld(World world) {
        this.disabledWorlds.add(world.getName());
    }

    public void removeDisabledWorld(World world) {
        this.disabledWorlds.remove(world.getName());
    }

    public void setDisabledWorlds(List<String> disabledWorlds) {
        this.disabledWorlds = disabledWorlds;
    }

    public String getEmptyPlaceholder() {
        return this.emptyPlaceholder;
    }

    public void setEmptyPlaceholder(String emptyPlaceholder) {
        this.emptyPlaceholder = emptyPlaceholder;
    }

    public Map<String, List<RolePermission>> getDefaultRoles() {
        return Collections.unmodifiableMap(this.defaultRoles);
    }

    public void setDefaultRoles(Map<String, List<RolePermission>> defaultRoles) {
        this.defaultRoles = defaultRoles;
    }

    public Integer getSettlementDefault(SettlementDefaultType type) {
        return this.settlementDefaults.get((Object)type);
    }

    public void setSettlementDefault(SettlementDefaultType type, int value) {
        this.settlementDefaults.put(type, value);
    }

    public void setSettlementDefaults(Map<SettlementDefaultType, Integer> settlementDefaults) {
        this.settlementDefaults = settlementDefaults;
    }

    public List<Flag> getFlags() {
        return Collections.unmodifiableList(this.flags);
    }

    public void setFlags(List<Flag> flags) {
        this.flags = flags;
    }

    public boolean isTrusting() {
        return this.trusting;
    }

    public void setTrusting(boolean trusting) {
        this.trusting = trusting;
    }

    public boolean isTeleportation() {
        return this.teleportation;
    }

    public boolean isHomes() {
        return this.homes;
    }

    public void setHomes(boolean homes) {
        this.homes = homes;
    }

    public void setTeleportation(boolean teleportation) {
        this.teleportation = teleportation;
    }

    public NotificationType getNotificationType() {
        return this.notificationType;
    }

    public void setNotificationType(NotificationType notificationType) {
        this.notificationType = notificationType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Config)) {
            return false;
        }
        Config config = (Config)o;
        return this.trusting == config.trusting && this.teleportation == config.teleportation && Objects.equals(this.disabledWorlds, config.disabledWorlds) && Objects.equals(this.flags, config.flags) && Objects.equals(this.emptyPlaceholder, config.emptyPlaceholder) && Objects.equals(this.defaultRoles, config.defaultRoles) && Objects.equals(this.settlementDefaults, config.settlementDefaults) && this.notificationType == config.notificationType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.disabledWorlds, this.flags, this.emptyPlaceholder, this.defaultRoles, this.settlementDefaults, this.trusting, this.teleportation, this.notificationType});
    }
}

