/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.services.implementations;

import com.google.gson.reflect.TypeToken;
import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.storage.Json;
import com.huskydreaming.settlements.services.interfaces.TrustService;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class TrustServiceImpl
implements TrustService {
    private Map<UUID, Set<String>> trusts;

    @Override
    public void deserialize(HuskyPlugin plugin) {
        int trustSize;
        Type type = new TypeToken<Map<UUID, Set<String>>>(){}.getType();
        this.trusts = (Map)Json.read((Plugin)plugin, "data/trust", type);
        if (this.trusts == null) {
            this.trusts = new ConcurrentHashMap<UUID, Set<String>>();
        }
        if ((trustSize = this.trusts.size()) > 0) {
            plugin.getLogger().info("Registered " + trustSize + " trusted chunks(s).");
        }
    }

    @Override
    public void serialize(HuskyPlugin plugin) {
        Json.write((Plugin)plugin, "data/trust", this.trusts);
    }

    @Override
    public void clean(String settlement) {
        List<UUID> uuids = this.trusts.entrySet().stream().filter(e -> ((Set)e.getValue()).contains(settlement)).map(Map.Entry::getKey).toList();
        for (UUID uuid : uuids) {
            this.trusts.remove(uuid);
        }
    }

    @Override
    public void trust(OfflinePlayer offlinePlayer, String string) {
        Set<String> settlements = this.trusts.get(offlinePlayer.getUniqueId());
        if (settlements != null) {
            settlements.add(string);
            return;
        }
        settlements = new HashSet<String>();
        settlements.add(string);
        this.trusts.put(offlinePlayer.getUniqueId(), settlements);
    }

    @Override
    public void unTrust(OfflinePlayer offlinePlayer, String string) {
        Set<String> settlements = this.trusts.get(offlinePlayer.getUniqueId());
        if (settlements == null) {
            return;
        }
        settlements.remove(string);
        if (!settlements.isEmpty()) {
            return;
        }
        this.trusts.remove(offlinePlayer.getUniqueId());
    }

    @Override
    public List<OfflinePlayer> getOfflinePlayers(String settlement) {
        return this.trusts.entrySet().stream().filter(entry -> ((Set)entry.getValue()).contains(settlement)).map(entry -> Bukkit.getOfflinePlayer((UUID)((UUID)entry.getKey()))).collect(Collectors.toList());
    }

    @Override
    public boolean hasTrusts(OfflinePlayer offlinePlayer) {
        return this.trusts.containsKey(offlinePlayer.getUniqueId());
    }

    @Override
    public Set<String> getSettlements(OfflinePlayer offlinePlayer) {
        return Collections.unmodifiableSet(this.trusts.get(offlinePlayer.getUniqueId()));
    }
}

