/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.services.implementations;

import com.google.gson.reflect.TypeToken;
import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.storage.Json;
import com.huskydreaming.settlements.SettlementPlugin;
import com.huskydreaming.settlements.enumeration.types.SettlementDefaultType;
import com.huskydreaming.settlements.services.interfaces.ConfigService;
import com.huskydreaming.settlements.services.interfaces.SettlementService;
import com.huskydreaming.settlements.storage.persistence.Config;
import com.huskydreaming.settlements.storage.persistence.Settlement;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SettlementServiceImpl
implements SettlementService {
    private final ConfigService configService;
    private Map<String, Settlement> settlements = new ConcurrentHashMap<String, Settlement>();

    public SettlementServiceImpl(SettlementPlugin plugin) {
        this.configService = plugin.provide(ConfigService.class);
    }

    @Override
    public void serialize(HuskyPlugin plugin) {
        Json.write((Plugin)plugin, "data/settlements", this.settlements);
        plugin.getLogger().info("Saved " + this.settlements.size() + " settlement(s).");
    }

    @Override
    public void deserialize(HuskyPlugin plugin) {
        int size;
        Type hashmap = new TypeToken<Map<String, Settlement>>(){}.getType();
        this.settlements = (Map)Json.read((Plugin)plugin, "data/settlements", hashmap);
        if (this.settlements == null) {
            this.settlements = new ConcurrentHashMap<String, Settlement>();
        }
        if ((size = this.settlements.size()) > 0) {
            plugin.getLogger().info("Registered " + size + " settlement(s).");
        }
    }

    @Override
    public Settlement createSettlement(Player player, String name) {
        Settlement settlement = Settlement.create(player);
        Config config = this.configService.getConfig();
        settlement.setMaxCitizens(config.getSettlementDefault(SettlementDefaultType.MAX_MEMBERS));
        settlement.setMaxLand(config.getSettlementDefault(SettlementDefaultType.MAX_CLAIMS));
        settlement.setMaxRoles(config.getSettlementDefault(SettlementDefaultType.MAX_ROLES));
        this.settlements.put(name, settlement);
        return settlement;
    }

    @Override
    public void disbandSettlement(String name) {
        this.settlements.remove(name);
    }

    @Override
    public boolean isSettlement(String name) {
        return this.settlements.containsKey(name.toLowerCase());
    }

    @Override
    public Settlement getSettlement(String string) {
        return this.settlements.get(string.toLowerCase());
    }

    @Override
    public Map<String, Settlement> getSettlements() {
        return Collections.unmodifiableMap(this.settlements);
    }
}

